/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.slab;

import cpw.mods.fml.common.registry.GameRegistry;
import mods.railcraft.common.blocks.BlockFactory;
import mods.railcraft.common.blocks.aesthetics.EnumBlockMaterial;
import mods.railcraft.common.blocks.aesthetics.slab.BlockRailcraftSlab;
import mods.railcraft.common.blocks.aesthetics.slab.ItemSlab;
import mods.railcraft.common.blocks.aesthetics.slab.TileSlab;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class BlockFactorySlab
extends BlockFactory {
    public BlockFactorySlab() {
        super("slab");
    }

    @Override
    protected void doBlockInit() {
        int renderId = Railcraft.getProxy().getRenderId();
        BlockRailcraftSlab.block = new BlockRailcraftSlab(renderId);
        BlockRailcraftSlab.block.func_149663_c("railcraft.slab");
        GameRegistry.registerBlock((Block)BlockRailcraftSlab.block, ItemSlab.class, (String)BlockRailcraftSlab.block.func_149739_a());
        GameRegistry.registerTileEntity(TileSlab.class, (String)"RCSlabTile");
        block3: for (EnumBlockMaterial mat : EnumBlockMaterial.VALUES) {
            RailcraftLanguage.instance().registerItemName(BlockRailcraftSlab.getItem(mat), BlockRailcraftSlab.getTag(mat));
            ItemRegistry.registerItemStack(BlockRailcraftSlab.getTag(mat), BlockRailcraftSlab.getItem(mat));
            switch (mat) {
                case SNOW: 
                case ICE: {
                    continue block3;
                }
                default: {
                    ForestryPlugin.addBackpackItem("builder", BlockRailcraftSlab.getItem(mat));
                }
            }
        }
    }

    @Override
    protected void doRecipeInit(ModuleManager.Module module) {
        EnumBlockMaterial.initialize();
        for (EnumBlockMaterial mat : EnumBlockMaterial.VALUES) {
            if (!BlockRailcraftSlab.isEnabled(mat) || mat.getSourceBlock() == null) continue;
            switch (mat) {
                case SNOW: {
                    CraftingPlugin.addShapedRecipe(BlockRailcraftSlab.getItem(mat, 3), "SSS", Character.valueOf('S'), Blocks.field_150433_aE);
                    break;
                }
                default: {
                    CraftingPlugin.addShapedRecipe(BlockRailcraftSlab.getItem(mat, 6), "SSS", Character.valueOf('S'), mat.getSourceItem());
                }
            }
            CraftingPlugin.addShapedRecipe(mat.getSourceItem(), "S", "S", Character.valueOf('S'), BlockRailcraftSlab.getItem(mat));
        }
    }
}

