/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.lamp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mods.railcraft.common.blocks.aesthetics.brick.BlockBrick;
import mods.railcraft.common.blocks.aesthetics.lamp.BlockStoneLamp;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public enum EnumStoneLamp {
    ABYSSAL,
    BLEACHEDBONE,
    BLOODSTAINED,
    FROSTBOUND,
    INFERNAL,
    NETHER,
    QUARRIED,
    SANDY,
    SANDSTONE,
    STONE;

    public static final EnumStoneLamp[] VALUES;
    public static final Map<String, EnumStoneLamp> NAMES;
    public static final List<EnumStoneLamp> creativeList;
    private ItemStack source;

    public static void initialize() {
        EnumStoneLamp.ABYSSAL.source = BlockBrick.abyssal.getItemStack(BlockBrick.BrickVariant.BLOCK, 1);
        EnumStoneLamp.BLEACHEDBONE.source = BlockBrick.bleachedbone.getItemStack(BlockBrick.BrickVariant.BLOCK, 1);
        EnumStoneLamp.BLOODSTAINED.source = BlockBrick.bloodstained.getItemStack(BlockBrick.BrickVariant.BLOCK, 1);
        EnumStoneLamp.FROSTBOUND.source = BlockBrick.frostbound.getItemStack(BlockBrick.BrickVariant.BLOCK, 1);
        EnumStoneLamp.INFERNAL.source = BlockBrick.infernal.getItemStack(BlockBrick.BrickVariant.BLOCK, 1);
        EnumStoneLamp.NETHER.source = BlockBrick.nether.getItemStack(BlockBrick.BrickVariant.BLOCK, 1);
        EnumStoneLamp.QUARRIED.source = BlockBrick.quarried.getItemStack(BlockBrick.BrickVariant.BLOCK, 1);
        EnumStoneLamp.SANDY.source = BlockBrick.sandy.getItemStack(BlockBrick.BrickVariant.BLOCK, 1);
        EnumStoneLamp.SANDSTONE.source = new ItemStack((Block)Blocks.field_150333_U, 1, 1);
        EnumStoneLamp.STONE.source = new ItemStack((Block)Blocks.field_150333_U, 1, 0);
        for (EnumStoneLamp lamp : VALUES) {
            NAMES.put(lamp.name(), lamp);
            if (lamp.isEnabled() && lamp.source != null) {
                CraftingPlugin.addShapedRecipe(lamp.getItem(1), " S ", " T ", " S ", Character.valueOf('S'), lamp.getSource(), Character.valueOf('T'), new ItemStack(Blocks.field_150478_aa));
            }
            creativeList.add(lamp);
        }
    }

    public static EnumStoneLamp fromOrdinal(int id) {
        if (id < 0 || id >= VALUES.length) {
            return VALUES[0];
        }
        return VALUES[id];
    }

    public static EnumStoneLamp fromName(String name) {
        EnumStoneLamp lamp = NAMES.get(name);
        if (lamp != null) {
            return lamp;
        }
        return ABYSSAL;
    }

    public IIcon getTexture(int side) {
        return InvTools.getBlockFromStack(this.source).func_149691_a(ForgeDirection.UP.ordinal(), this.source.func_77960_j());
    }

    public Block getBlock() {
        return BlockStoneLamp.getBlock();
    }

    public ItemStack getSource() {
        if (this.source == null) {
            return null;
        }
        return this.source.func_77946_l();
    }

    public ItemStack getItem() {
        return this.getItem(1);
    }

    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    public String getTag() {
        return "railcraft.stonelamp." + this.name().replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(ModuleManager.Module.STRUCTURES) && RailcraftConfig.isSubBlockEnabled(this.getTag()) && this.getBlock() != null;
    }

    static {
        VALUES = EnumStoneLamp.values();
        NAMES = new HashMap<String, EnumStoneLamp>();
        creativeList = new ArrayList<EnumStoneLamp>();
    }
}

