/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.core.INetworkedObject;
import mods.railcraft.api.core.IOwnable;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.PacketBuilder;
import mods.railcraft.common.util.network.PacketTileEntity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class RailcraftTileEntity
extends TileEntity
implements INetworkedObject,
IOwnable {
    private String owner = "[Railcraft]";
    protected int clock = MiscTools.getRand().nextInt();
    private boolean sendClientUpdate = false;

    public void func_145845_h() {
        super.func_145845_h();
        ++this.clock;
        if (this.sendClientUpdate) {
            this.sendClientUpdate = false;
            PacketBuilder.instance().sendTileEntityPacket(this);
        }
    }

    public FMLProxyPacket getDescriptionPacket() {
        PacketTileEntity packet = new PacketTileEntity(this);
        return packet.getPacket();
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
    }

    public void markBlockForUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void notifyBlocksOfNeighborChange() {
        if (this.field_145850_b != null) {
            WorldPlugin.notifyBlocksOfNeighborChange(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    public void sendUpdateToClient() {
        if (this.canUpdate()) {
            this.sendClientUpdate = true;
        } else {
            PacketBuilder.instance().sendTileEntityPacket(this);
        }
    }

    public void onBlockPlacedBy(EntityLivingBase entityliving) {
        String name;
        if (entityliving instanceof EntityPlayer && (name = ((EntityPlayer)entityliving).getDisplayName()) != null) {
            this.owner = name;
        }
    }

    public final int getDimension() {
        if (this.field_145850_b == null) {
            return 0;
        }
        return this.field_145850_b.field_73011_w.field_76574_g;
    }

    @Override
    public final String getOwner() {
        return this.owner;
    }

    public boolean isOwner(String username) {
        return this.owner.equals(username);
    }

    public abstract String getName();

    public static boolean isUseableByPlayerHelper(TileEntity tile, EntityPlayer player) {
        if (tile.func_145831_w().func_147438_o(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e) != tile) {
            return false;
        }
        return player.func_70092_e((double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e) <= 64.0;
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74778_a("owner", this.owner);
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.owner = data.func_74779_i("owner");
    }

    public final int getX() {
        return this.field_145851_c;
    }

    public final int getY() {
        return this.field_145848_d;
    }

    public final int getZ() {
        return this.field_145849_e;
    }

    @Override
    public final World getWorld() {
        return this.field_145850_b;
    }

    public abstract short getId();
}

