/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import mods.railcraft.common.blocks.machine.BlockMachine;
import mods.railcraft.common.blocks.machine.ItemMachine;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.alpha.MachineProxyAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.MachineProxyBeta;
import mods.railcraft.common.blocks.machine.delta.EnumMachineDelta;
import mods.railcraft.common.blocks.machine.delta.MachineProxyDelta;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.MachineProxyGamma;
import mods.railcraft.common.blocks.signals.BlockSignal;
import mods.railcraft.common.blocks.signals.ItemSignal;
import mods.railcraft.common.blocks.tracks.BlockTrack;
import mods.railcraft.common.blocks.tracks.BlockTrackElevator;
import mods.railcraft.common.blocks.tracks.ItemTrack;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.RailcraftPartItems;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class RailcraftBlocks {
    private static Block blockMachineAlpha;
    private static Block blockMachineBeta;
    private static Block blockMachineGamma;
    private static Block blockMachineDelta;
    private static Block blockTrack;
    private static Block blockRailElevator;
    private static Block blockSignal;

    public static void registerBlockTrack() {
        if (blockTrack == null && RailcraftConfig.isBlockEnabled("track")) {
            int renderId = Railcraft.getProxy().getRenderId();
            blockTrack = new BlockTrack(renderId).func_149663_c("railcraft.track");
            GameRegistry.registerBlock((Block)blockTrack, ItemTrack.class, (String)blockTrack.func_149739_a());
            blockTrack.setHarvestLevel("crowbar", 0);
            blockTrack.setHarvestLevel("pickaxe", 0);
        }
    }

    public static Block getBlockTrack() {
        return blockTrack;
    }

    public static void registerBlockRailElevator() {
        if (blockRailElevator == null && RailcraftConfig.isBlockEnabled("elevator")) {
            int renderId = Railcraft.getProxy().getRenderId();
            blockRailElevator = new BlockTrackElevator(renderId).func_149663_c("railcraft.track.elevator");
            GameRegistry.registerBlock((Block)blockRailElevator, (String)blockRailElevator.func_149739_a());
            blockRailElevator.setHarvestLevel("crowbar", 0);
            blockRailElevator.setHarvestLevel("pickaxe", 0);
            ItemStack stackElevator = new ItemStack(blockRailElevator, 8);
            CraftingPlugin.addShapedRecipe(stackElevator, "IRI", "ISI", "IRI", Character.valueOf('I'), RailcraftConfig.useOldRecipes() ? Items.field_151043_k : RailcraftPartItems.getRailAdvanced(), Character.valueOf('S'), RailcraftConfig.useOldRecipes() ? Items.field_151042_j : RailcraftPartItems.getRailStandard(), Character.valueOf('R'), Items.field_151137_ax);
            RailcraftLanguage.instance().registerItemName(stackElevator, "track.elevator");
            ItemRegistry.registerItemStack("track.elevator", stackElevator);
        }
    }

    public static Block getBlockElevator() {
        return blockRailElevator;
    }

    public static void registerBlockMachineAlpha() {
        if (blockMachineAlpha == null && RailcraftConfig.isBlockEnabled("machine.alpha")) {
            int[] lightOpacity = new int[16];
            Arrays.fill(lightOpacity, 255);
            blockMachineAlpha = new BlockMachine(0, new MachineProxyAlpha(), true, lightOpacity).func_149663_c("railcraft.machine.alpha");
            GameRegistry.registerBlock((Block)blockMachineAlpha, ItemMachine.class, (String)blockMachineAlpha.func_149739_a());
            block4: for (EnumMachineAlpha type : EnumMachineAlpha.values()) {
                switch (type) {
                    case FEED_STATION: 
                    case TANK_WATER: {
                        blockMachineAlpha.setHarvestLevel("axe", 1, type.ordinal());
                        blockMachineAlpha.setHarvestLevel("crowbar", 0, type.ordinal());
                        continue block4;
                    }
                    case WORLD_ANCHOR: 
                    case PERSONAL_ANCHOR: {
                        blockMachineAlpha.setHarvestLevel("pickaxe", 3, type.ordinal());
                        blockMachineAlpha.setHarvestLevel("crowbar", 0, type.ordinal());
                        continue block4;
                    }
                    default: {
                        blockMachineAlpha.setHarvestLevel("pickaxe", 2, type.ordinal());
                        blockMachineAlpha.setHarvestLevel("crowbar", 0, type.ordinal());
                    }
                }
            }
        }
    }

    public static Block getBlockMachineAlpha() {
        return blockMachineAlpha;
    }

    public static void registerBlockMachineBeta() {
        if (blockMachineBeta == null && RailcraftConfig.isBlockEnabled("machine.beta")) {
            int renderId = Railcraft.getProxy().getRenderId();
            int[] lightOpacity = new int[16];
            Arrays.fill(lightOpacity, 255);
            lightOpacity[EnumMachineBeta.ENGINE_STEAM_HOBBY.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.ENGINE_STEAM_LOW.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.ENGINE_STEAM_HIGH.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.TANK_IRON_WALL.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.TANK_IRON_VALVE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.TANK_IRON_GAUGE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.TANK_STEEL_WALL.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.TANK_STEEL_VALVE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.TANK_STEEL_GAUGE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.BOILER_TANK_LOW_PRESSURE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.BOILER_TANK_HIGH_PRESSURE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.SENTINEL.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.VOID_CHEST.ordinal()] = 0;
            blockMachineBeta = new BlockMachine(renderId, new MachineProxyBeta(), false, lightOpacity).func_149663_c("railcraft.machine.beta");
            GameRegistry.registerBlock((Block)blockMachineBeta, ItemMachine.class, (String)blockMachineBeta.func_149739_a());
            block3: for (EnumMachineBeta type : EnumMachineBeta.values()) {
                switch (type) {
                    case SENTINEL: {
                        blockMachineBeta.setHarvestLevel("pickaxe", 3, type.ordinal());
                        blockMachineBeta.setHarvestLevel("crowbar", 0, type.ordinal());
                        continue block3;
                    }
                    default: {
                        blockMachineBeta.setHarvestLevel("pickaxe", 2, type.ordinal());
                        blockMachineBeta.setHarvestLevel("crowbar", 0, type.ordinal());
                    }
                }
            }
        }
    }

    public static Block getBlockMachineBeta() {
        return blockMachineBeta;
    }

    public static void registerBlockMachineGamma() {
        if (blockMachineGamma == null && RailcraftConfig.isBlockEnabled("machine.gamma")) {
            int[] lightOpacity = new int[16];
            Arrays.fill(lightOpacity, 255);
            lightOpacity[EnumMachineGamma.LIQUID_LOADER.ordinal()] = 0;
            lightOpacity[EnumMachineGamma.LIQUID_UNLOADER.ordinal()] = 0;
            blockMachineGamma = new BlockMachine(0, new MachineProxyGamma(), false, lightOpacity).func_149663_c("railcraft.machine.gamma");
            blockMachineGamma.func_149647_a(CreativeTabs.field_78029_e);
            GameRegistry.registerBlock((Block)blockMachineGamma, ItemMachine.class, (String)blockMachineGamma.func_149739_a());
            for (EnumMachineGamma type : EnumMachineGamma.values()) {
                switch (type) {
                    default: 
                }
                blockMachineGamma.setHarvestLevel("pickaxe", 2, type.ordinal());
                blockMachineGamma.setHarvestLevel("crowbar", 0, type.ordinal());
            }
        }
    }

    public static Block getBlockMachineGamma() {
        return blockMachineGamma;
    }

    public static void registerBlockMachineDelta() {
        if (blockMachineDelta == null && RailcraftConfig.isBlockEnabled("machine.delta")) {
            int renderId = Railcraft.getProxy().getRenderId();
            int[] lightOpacity = new int[16];
            Arrays.fill(lightOpacity, 255);
            lightOpacity[EnumMachineDelta.CAGE.ordinal()] = 0;
            blockMachineDelta = new BlockMachine(renderId, new MachineProxyDelta(), false, lightOpacity).func_149663_c("railcraft.machine.delta");
            blockMachineDelta.func_149647_a(CreativePlugin.RAILCRAFT_TAB);
            GameRegistry.registerBlock((Block)blockMachineDelta, ItemMachine.class, (String)blockMachineDelta.func_149739_a());
            for (EnumMachineDelta type : EnumMachineDelta.values()) {
                switch (type) {
                    default: 
                }
                blockMachineDelta.setHarvestLevel("pickaxe", 2, type.ordinal());
                blockMachineDelta.setHarvestLevel("crowbar", 0, type.ordinal());
            }
        }
    }

    public static Block getBlockMachineDelta() {
        return blockMachineDelta;
    }

    public static void registerBlockSignal() {
        if (blockSignal == null && RailcraftConfig.isBlockEnabled("signal")) {
            int renderId = Railcraft.getProxy().getRenderId();
            blockSignal = new BlockSignal(renderId);
            GameRegistry.registerBlock((Block)blockSignal, ItemSignal.class, (String)blockSignal.func_149739_a());
            blockSignal.setHarvestLevel("pickaxe", 2);
            blockSignal.setHarvestLevel("crowbar", 0);
        }
    }

    public static Block getBlockSignal() {
        return blockSignal;
    }
}

