/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.util.textures;

import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.imageio.ImageIO;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class TextureAtlasSheet
extends TextureAtlasSprite {
    private final int index;
    private final int rows;
    private final int columns;

    public static IIcon[] unstitchIcons(IIconRegister iconRegister, String name, int numIcons) {
        return TextureAtlasSheet.unstitchIcons(iconRegister, name, numIcons, 1);
    }

    public static IIcon[] unstitchIcons(IIconRegister iconRegister, String name, int columns, int rows) {
        TextureMap textureMap = (TextureMap)iconRegister;
        int numIcons = rows * columns;
        IIcon[] icons = new IIcon[numIcons];
        for (int i = 0; i < numIcons; ++i) {
            String texName = name + "." + i;
            TextureAtlasSheet texture = new TextureAtlasSheet(texName, i, rows, columns);
            textureMap.setTextureEntry(texName, (TextureAtlasSprite)texture);
            icons[i] = texture;
        }
        return icons;
    }

    private TextureAtlasSheet(String name, int index, int rows, int columns) {
        super(name);
        this.index = index;
        this.rows = rows;
        this.columns = columns;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        BufferedImage subImage;
        int mipmapLevels;
        Field anisotropicFiltering;
        Field mipmapLevel;
        BufferedImage image;
        int split = (location = new ResourceLocation(location.func_110624_b(), location.func_110623_a().replace("." + this.index, ""))).func_110623_a().indexOf(58);
        if (split != -1) {
            location = new ResourceLocation(location.func_110624_b(), location.func_110623_a().substring(0, split));
        }
        location = new ResourceLocation(location.func_110624_b(), "textures/blocks/" + location.func_110623_a() + ".png");
        try {
            IResource res = manager.func_110536_a(location);
            image = ImageIO.read(res.func_110527_b());
        }
        catch (IOException ex) {
            Game.log(Level.WARN, "Failed to load sub-texture from {0}: {1}", location.func_110623_a(), ex.getLocalizedMessage());
            return true;
        }
        try {
            mipmapLevel = TextureMap.class.getDeclaredField("field_147636_j");
            anisotropicFiltering = TextureMap.class.getDeclaredField("field_147637_k");
        }
        catch (NoSuchFieldException e) {
            try {
                mipmapLevel = TextureMap.class.getDeclaredField("mipmapLevels");
                anisotropicFiltering = TextureMap.class.getDeclaredField("anisotropicFiltering");
            }
            catch (NoSuchFieldException f) {
                throw new RuntimeException(f);
            }
        }
        mipmapLevel.setAccessible(true);
        anisotropicFiltering.setAccessible(true);
        try {
            mipmapLevels = mipmapLevel.getInt(Minecraft.func_71410_x().func_147117_R());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int size = image.getHeight() / this.rows;
        int x = this.index % this.columns;
        int y = this.index / this.columns;
        try {
            subImage = image.getSubimage(x * size, y * size, size, size);
        }
        catch (RasterFormatException ex) {
            Game.log(Level.WARN, "Failed to load sub-texture from {0} - {1}x{2}: {3}", location.func_110623_a(), image.getWidth(), image.getHeight(), ex.getLocalizedMessage());
            return true;
        }
        this.field_130224_d = subImage.getHeight();
        this.field_130223_c = subImage.getWidth();
        int[] rgbaData = new int[this.field_130224_d * this.field_130223_c];
        subImage.getRGB(0, 0, this.field_130223_c, this.field_130224_d, rgbaData, 0, this.field_130223_c);
        int[][] imageData = new int[1 + mipmapLevels][];
        imageData[0] = rgbaData;
        this.field_110976_a.add(imageData);
        return false;
    }
}

