/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import cpw.mods.fml.common.registry.VillagerRegistry;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiBetterButton;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.alpha.TileTradeStation;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.buttons.StandardButtonTextureSets;
import mods.railcraft.common.gui.containers.ContainerTradeStation;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.gui.tooltips.ToolTipLine;
import mods.railcraft.common.util.collections.RevolvingList;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.EnumChatFormatting;

public class GuiTradeStation
extends TileGui {
    private static final String label = RailcraftLanguage.translate(EnumMachineAlpha.TRADE_STATION.getTag());
    private final TileTradeStation tile;
    private final RevolvingList<Integer> professions = new RevolvingList();
    private final EntityVillager villager;

    public GuiTradeStation(InventoryPlayer playerInv, TileTradeStation tile) {
        super(tile, new ContainerTradeStation(playerInv, tile), "railcraft:textures/gui/gui_trade_station.png");
        this.field_146999_f = 176;
        this.field_147000_g = 214;
        this.tile = tile;
        this.villager = new EntityVillager(tile.getWorld());
        for (int prof = 0; prof < 5; ++prof) {
            this.professions.add(prof);
        }
        this.professions.addAll(VillagerRegistry.getRegisteredVillagers());
        this.professions.setCurrent(tile.getProfession());
        this.villager.func_70938_b(this.professions.getCurrent().intValue());
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int w = (this.field_146294_l - this.field_146999_f) / 2;
        int h = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiBetterButton(0, w + 118, h + 64, 10, StandardButtonTextureSets.LEFT_BUTTON, ""));
        this.field_146292_n.add(new GuiBetterButton(1, w + 156, h + 64, 10, StandardButtonTextureSets.RIGHT_BUTTON, ""));
        GuiBetterButton[] dice = new GuiBetterButton[3];
        ToolTip tip = ToolTip.buildToolTip("gui.trade.station.dice.tip", new String[0]);
        ((ToolTipLine)tip.get((int)0)).format = EnumChatFormatting.YELLOW;
        for (int b = 0; b < 3; ++b) {
            dice[b] = new GuiBetterButton(2 + b, w + 93, h + 24 + 21 * b, 16, StandardButtonTextureSets.DICE_BUTTON, "");
            dice[b].setToolTip(tip);
            this.field_146292_n.add(dice[b]);
        }
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 0: {
                this.professions.rotateLeft();
                this.sendUpdateToTile(TileTradeStation.GuiPacketType.SET_PROFESSION, this.professions.getCurrent());
                break;
            }
            case 1: {
                this.professions.rotateRight();
                this.sendUpdateToTile(TileTradeStation.GuiPacketType.SET_PROFESSION, this.professions.getCurrent());
                break;
            }
            case 2: {
                this.sendUpdateToTile(TileTradeStation.GuiPacketType.NEXT_TRADE, (byte)0);
                break;
            }
            case 3: {
                this.sendUpdateToTile(TileTradeStation.GuiPacketType.NEXT_TRADE, (byte)1);
                break;
            }
            case 4: {
                this.sendUpdateToTile(TileTradeStation.GuiPacketType.NEXT_TRADE, (byte)2);
            }
        }
        this.villager.func_70938_b(this.professions.getCurrent().intValue());
    }

    public void sendUpdateToTile(TileTradeStation.GuiPacketType type, Object ... args) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeByte(type.ordinal());
            for (Object arg : args) {
                if (arg instanceof Integer) {
                    data.writeInt((Integer)arg);
                    continue;
                }
                if (!(arg instanceof Byte)) continue;
                data.writeByte(((Byte)arg).byteValue());
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        PacketBuilder.instance().sendGuiReturnPacket(this.tile, bytes.toByteArray());
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int sWidth = this.field_146289_q.func_78256_a(label);
        int sPos = this.field_146999_f / 2 - sWidth / 2;
        this.field_146289_q.func_78276_b(label, sPos, 6, 0x404040);
        GuiTools.drawVillager(this.villager, 141, 79, 30, (float)(this.field_147003_i + 87) - (float)mouseX, (float)(this.field_147009_r + 91 - 50) - (float)mouseY);
    }
}

