/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.client.gui.GuiContainerRailcraft;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.buttons.GuiMultiButton;
import mods.railcraft.client.gui.buttons.GuiToggleButton;
import mods.railcraft.common.blocks.signals.IAspectActionManager;
import mods.railcraft.common.gui.buttons.LockButtonState;
import mods.railcraft.common.gui.containers.ContainerAspectAction;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;

public class GuiAspectAction
extends GuiContainerRailcraft {
    private final IAspectActionManager actionManager;
    private final String title;
    private final EntityPlayer player;
    private final boolean[] aspects = new boolean[SignalAspect.values().length];
    private GuiMultiButton lockButton;
    private boolean changed;
    private ToolTip lockedToolTips;
    private ToolTip unlockedToolTips;
    private ToolTip notownedToolTips;
    public String owner = "[Unknown]";

    public GuiAspectAction(EntityPlayer player, IAspectActionManager actionManager, String title) {
        super(new ContainerAspectAction(player, actionManager), "railcraft:textures/gui/gui_basic.png");
        this.field_147000_g = 88;
        this.player = player;
        this.actionManager = actionManager;
        this.title = title;
        for (SignalAspect aspect : SignalAspect.values()) {
            this.aspects[aspect.ordinal()] = actionManager.doesActionOnAspect(aspect);
        }
        this.lockedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.locked", "{owner}=" + this.owner);
        this.unlockedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.unlocked", "{owner}=" + this.owner);
        this.notownedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.notowner", "{owner}=" + this.owner);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.actionManager == null) {
            return;
        }
        this.field_146292_n.clear();
        int w = (this.field_146294_l - this.field_146999_f) / 2;
        int h = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiToggleButton(0, w + 7, h + 30, 50, "Green", this.aspects[SignalAspect.GREEN.ordinal()]));
        this.field_146292_n.add(new GuiToggleButton(1, w + 12, h + 55, 70, "Blink Yellow", this.aspects[SignalAspect.BLINK_YELLOW.ordinal()]));
        this.field_146292_n.add(new GuiToggleButton(2, w + 63, h + 30, 50, "Yellow", this.aspects[SignalAspect.YELLOW.ordinal()]));
        this.field_146292_n.add(new GuiToggleButton(3, w + 94, h + 55, 70, "Blink Red", this.aspects[SignalAspect.BLINK_RED.ordinal()]));
        this.field_146292_n.add(new GuiToggleButton(4, w + 119, h + 30, 50, "Red", this.aspects[SignalAspect.RED.ordinal()]));
        this.lockButton = new GuiMultiButton(5, w + 152, h + 8, 16, this.actionManager.getLockController());
        this.field_146292_n.add(this.lockButton);
        this.lockButton.field_146124_l = false;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GuiTools.drawCenteredString(this.field_146289_q, this.title, 15);
    }

    protected void func_146284_a(GuiButton button) {
        if (this.actionManager == null) {
            return;
        }
        if (!button.field_146124_l) {
            return;
        }
        if (!this.canChange()) {
            return;
        }
        this.changed = true;
        if (button instanceof GuiToggleButton) {
            SignalAspect aspect = SignalAspect.values()[button.field_146127_k];
            this.aspects[aspect.ordinal()] = !this.aspects[aspect.ordinal()];
            ((GuiToggleButton)button).active = this.aspects[aspect.ordinal()];
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.lockButton.field_146124_l = ((ContainerAspectAction)this.container).canLock;
        this.lockButton.setToolTip(this.actionManager.getLockController().getButtonState() == LockButtonState.LOCKED ? this.lockedToolTips : (this.lockButton.field_146124_l ? this.unlockedToolTips : this.notownedToolTips));
        String own = ((ContainerAspectAction)this.container).owner;
        if (!own.equals(this.owner)) {
            this.owner = own;
            this.lockedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.locked", "{owner}=" + this.owner);
            this.unlockedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.unlocked", "{owner}=" + this.owner);
            this.notownedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.notowner", "{owner}=" + this.owner);
        }
    }

    public void func_146281_b() {
        if (this.changed && this.actionManager instanceof IGuiReturnHandler && this.canChange()) {
            for (SignalAspect aspect : SignalAspect.values()) {
                this.actionManager.doActionOnAspect(aspect, this.aspects[aspect.ordinal()]);
            }
            PacketGuiReturn pkt = new PacketGuiReturn((IGuiReturnHandler)((Object)this.actionManager));
            PacketDispatcher.sendToServer(pkt);
        }
    }

    private boolean canChange() {
        return this.actionManager.getLockController().getButtonState() == LockButtonState.UNLOCKED || ((ContainerAspectAction)this.container).canLock;
    }
}

