/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.AbstractPair;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SignalReceiver;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketPairUpdate;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PacketPairRequest
extends RailcraftPacket {
    private AbstractPair pairing;
    private EntityPlayerMP player;
    private RailcraftPacket.PacketType packetType;

    public PacketPairRequest(EntityPlayerMP player, RailcraftPacket.PacketType type) {
        this.player = player;
        this.packetType = type;
    }

    public PacketPairRequest(AbstractPair pairing) {
        this.pairing = pairing;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        TileEntity tile = this.pairing.getTile();
        data.writeInt(tile.func_145831_w().field_73011_w.field_76574_g);
        data.writeInt(tile.field_145851_c);
        data.writeInt(tile.field_145848_d);
        data.writeInt(tile.field_145849_e);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        WorldServer world = DimensionManager.getWorld((int)data.readInt());
        if (world == null) {
            return;
        }
        int x = data.readInt();
        int y = data.readInt();
        int z = data.readInt();
        TileEntity tile = world.func_147438_o(x, y, z);
        switch (this.packetType) {
            case CONTROLLER_REQUEST: {
                if (!(tile instanceof IControllerTile)) break;
                this.pairing = ((IControllerTile)tile).getController();
                break;
            }
            case RECEIVER_REQUEST: {
                if (!(tile instanceof IReceiverTile)) break;
                this.pairing = ((IReceiverTile)tile).getReceiver();
            }
        }
        if (this.pairing != null && this.player != null) {
            PacketPairUpdate pkt = new PacketPairUpdate(this.pairing);
            PacketDispatcher.sendToPlayer(pkt, this.player);
        }
    }

    @Override
    public int getID() {
        if (this.pairing instanceof SignalController) {
            return RailcraftPacket.PacketType.CONTROLLER_REQUEST.ordinal();
        }
        if (this.pairing instanceof SignalReceiver) {
            return RailcraftPacket.PacketType.RECEIVER_REQUEST.ordinal();
        }
        return -1;
    }
}

