/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.misc;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.Timer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public final class AdjacentTileCache {
    private static final int DELAY_MIN = 20;
    private static final int DELAY_MAX = 2400;
    private static final int DELAY_STEP = 2;
    private final Timer[] timer = new Timer[6];
    private final TileEntity[] cache = new TileEntity[6];
    private final int[] delay = new int[6];
    private final TileEntity source;
    private final Set<ICacheListener> listeners = new LinkedHashSet<ICacheListener>();

    public AdjacentTileCache(TileEntity tile) {
        this.source = tile;
        Arrays.fill(this.delay, 20);
        for (int i = 0; i < this.timer.length; ++i) {
            this.timer[i] = new Timer();
        }
    }

    public void addListener(ICacheListener listener) {
        this.listeners.add(listener);
    }

    private TileEntity searchSide(ForgeDirection side) {
        return WorldPlugin.getTileEntityOnSide(this.source.func_145831_w(), this.source.field_145851_c, this.source.field_145848_d, this.source.field_145849_e, side);
    }

    public void refresh() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.getTileOnSide(side);
        }
    }

    public void purge() {
        Arrays.fill(this.cache, null);
        Arrays.fill(this.delay, 20);
        for (Timer t : this.timer) {
            t.reset();
        }
        this.changed();
        for (ICacheListener listener : this.listeners) {
            listener.purge();
        }
    }

    public void onNeighborChange() {
        Arrays.fill(this.delay, 20);
    }

    protected void setTile(int side, TileEntity tile) {
        if (this.cache[side] != tile) {
            this.cache[side] = tile;
            this.changed();
        }
    }

    private void changed() {
        for (ICacheListener listener : this.listeners) {
            listener.changed();
        }
    }

    public TileEntity getTileOnSide(ForgeDirection side) {
        int s = side.ordinal();
        if (this.cache[s] != null) {
            if (this.cache[s].func_145837_r() || !MiscTools.areCoordinatesOnSide(this.source.field_145851_c, this.source.field_145848_d, this.source.field_145849_e, side, this.cache[s].field_145851_c, this.cache[s].field_145848_d, this.cache[s].field_145849_e)) {
                this.setTile(s, null);
            } else {
                return this.cache[s];
            }
        }
        if (this.timer[s].hasTriggered(this.source.func_145831_w(), this.delay[s])) {
            this.setTile(s, this.searchSide(side));
            if (this.cache[s] == null) {
                this.incrementDelay(s);
            } else {
                this.delay[s] = 20;
            }
        }
        return this.cache[s];
    }

    private void incrementDelay(int side) {
        int n = side;
        this.delay[n] = this.delay[n] + 2;
        if (this.delay[side] > 2400) {
            this.delay[side] = 2400;
        }
    }

    public static interface ICacheListener {
        public void changed();

        public void purge();
    }
}

