/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.AdjacentTileCache;
import mods.railcraft.common.util.misc.ITileFilter;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public final class AdjacentInventoryCache {
    private final AdjacentTileCache cache;
    private boolean changed = true;
    private final List<IInventory> invs = new LinkedList<IInventory>();
    private final Comparator<IInventory> sorter;
    private final ITileFilter filter;

    public AdjacentInventoryCache(TileEntity tile, AdjacentTileCache cache) {
        this(tile, cache, null, null);
    }

    public AdjacentInventoryCache(TileEntity tile, AdjacentTileCache cache, ITileFilter filter, Comparator<IInventory> sorter) {
        this.cache = cache;
        cache.addListener(new AdjacentTileCache.ICacheListener(){

            @Override
            public void changed() {
                AdjacentInventoryCache.this.changed = true;
            }

            @Override
            public void purge() {
                AdjacentInventoryCache.this.invs.clear();
            }
        });
        this.filter = filter;
        this.sorter = sorter;
    }

    public Collection<IInventory> getAdjecentInventories() {
        this.cache.refresh();
        if (this.changed) {
            this.changed = false;
            this.invs.clear();
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                IInventory inv;
                TileEntity tile = this.cache.getTileOnSide(side);
                if (tile == null || this.filter != null && !this.filter.matches(tile) || (inv = InvTools.getInventoryFromTile(tile, side.getOpposite())) == null) continue;
                this.invs.add(inv);
            }
            if (this.sorter != null) {
                Collections.sort(this.invs, this.sorter);
            }
        }
        return this.invs;
    }
}

