/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forestry;

import mods.railcraft.api.core.items.IMinecartItem;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.detector.BlockDetector;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.signals.ItemSignalBlockSurveyor;
import mods.railcraft.common.blocks.signals.ItemSignalTuner;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.fluids.FluidContainers;
import mods.railcraft.common.items.ItemCircuit;
import mods.railcraft.common.items.ItemCrowbar;
import mods.railcraft.common.items.ItemCrowbarReinforced;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.items.ItemMagnifyingGlass;
import mods.railcraft.common.items.ItemWhistleTuner;
import mods.railcraft.common.items.RailcraftPartItems;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.plugins.forestry.BaseBackpack;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMinecart;

public class TrackmanBackpack
extends BaseBackpack {
    private static TrackmanBackpack instance;

    public static TrackmanBackpack getInstance() {
        if (instance == null) {
            instance = new TrackmanBackpack();
        }
        return instance;
    }

    protected TrackmanBackpack() {
    }

    public void setup() {
        this.addValidItem(ItemCrowbar.getItem());
        this.addValidItem(ItemCrowbarReinforced.getItem());
        this.addValidItem(ItemWhistleTuner.getItem());
        this.addValidItem(ItemMagnifyingGlass.getItem());
        this.addValidItem(ItemGoggles.getItem());
        this.addValidItem(ItemCircuit.getCircuitItem());
        this.addValidItem(ItemSignalBlockSurveyor.getItem());
        this.addValidItem(ItemSignalTuner.getItem());
        this.addValidItem(RailcraftToolItems.getOveralls());
        for (Object id : Block.field_149771_c.func_148742_b()) {
            Block block = (Block)Block.field_149771_c.func_82594_a(id);
            if (block == null || !TrackTools.isRailBlock(block)) continue;
            this.addValidItem(block);
        }
        for (Object id : Item.field_150901_e.func_148742_b()) {
            Item item = (Item)Item.field_150901_e.func_82594_a(id);
            if (!(item instanceof ItemMinecart) && !(item instanceof IMinecartItem)) continue;
            this.addValidItem(item);
        }
        this.addValidItem(FluidContainers.getCreosoteOilBottle());
        this.addValidItem(FluidContainers.getCreosoteOilBucket());
        this.addValidItem(FluidContainers.getCreosoteOilCell());
        this.addValidItem(FluidContainers.getCreosoteOilCan());
        this.addValidItem(FluidContainers.getCreosoteOilRefactory());
        this.addValidItem(FluidContainers.getCreosoteOilWax());
        this.addValidItem(EnumMachineAlpha.WORLD_ANCHOR.getItem());
        this.addValidItem(EnumMachineAlpha.PERSONAL_ANCHOR.getItem());
        this.addValidItem(EnumMachineBeta.SENTINEL.getItem());
        this.addValidItem(RailcraftPartItems.itemRail);
        this.addValidItem(RailcraftPartItems.itemRailbed);
        this.addValidItem(RailcraftPartItems.itemTie);
        this.addValidItem(RailcraftPartItems.itemSignalLamp);
        this.addValidItem(RailcraftBlocks.getBlockMachineGamma());
        this.addValidItem(RailcraftBlocks.getBlockElevator());
        this.addValidItem(RailcraftBlocks.getBlockSignal());
        this.addValidItem((Block)BlockDetector.getBlock());
    }

    @Override
    public String getKey() {
        return "TRACKMAN";
    }

    @Override
    public String getName() {
        return RailcraftLanguage.translate("backpack.trackman.t1");
    }

    @Override
    public int getPrimaryColour() {
        return 38143;
    }

    @Override
    public int getSecondaryColour() {
        return 0xFFFFFF;
    }
}

