/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.buildcraft.triggers;

import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.ITileTrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.TriggerParameter;
import java.util.EnumSet;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.common.blocks.machine.beta.TileEngine;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.buildcraft.triggers.Trigger;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerAspect;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerEngine;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerHasCart;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerHasWork;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerLowFuel;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerMaintenance;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerTemp;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public enum Triggers implements ITileTrigger
{
    HAS_WORK(400, "work", new TriggerHasWork()),
    HAS_CART(401, "cart", new TriggerHasCart()),
    ENGINE_BLUE(402, "engine.blue", new TriggerEngine(EnumSet.of(TileEngine.EnergyStage.BLUE))),
    ENGINE_GREEN(403, "engine.green", new TriggerEngine(EnumSet.of(TileEngine.EnergyStage.GREEN))),
    ENGINE_YELLOW(404, "engine.yellow", new TriggerEngine(EnumSet.of(TileEngine.EnergyStage.YELLOW))),
    ENGINE_ORANGE(405, "engine.orange", new TriggerEngine(EnumSet.of(TileEngine.EnergyStage.ORANGE))),
    ENGINE_RED(406, "engine.red", new TriggerEngine(EnumSet.of(TileEngine.EnergyStage.RED, TileEngine.EnergyStage.OVERHEAT))),
    LOW_FUEL(407, "fuel", new TriggerLowFuel()),
    TEMP_COLD(408, "temp.cold", new TriggerTemp(0, 100)),
    TEMP_WARM(409, "temp.warm", new TriggerTemp(100, 300)),
    TEMP_HOT(410, "temp.hot", new TriggerTemp(300, Integer.MAX_VALUE)),
    NEEDS_MAINT(411, "maintenance", new TriggerMaintenance()),
    ASPECT_GREEN(412, "aspect.green", new TriggerAspect(SignalAspect.GREEN)),
    ASPECT_BLINK_YELLOW(413, "aspect.yellow.blink", new TriggerAspect(SignalAspect.BLINK_YELLOW)),
    ASPECT_YELLOW(414, "aspect.yellow", new TriggerAspect(SignalAspect.YELLOW)),
    ASPECT_BLINK_RED(415, "aspect.red.blink", new TriggerAspect(SignalAspect.BLINK_RED)),
    ASPECT_RED(416, "aspect.red", new TriggerAspect(SignalAspect.RED)),
    ASPECT_OFF(417, "aspect.off", new TriggerAspect(SignalAspect.OFF));

    public static final Triggers[] VALUES;
    private final Trigger trigger;
    private final int id;
    private final String tag;
    private IIcon icon;

    private Triggers(int id, String tag, Trigger trigger) {
        this.id = id;
        this.tag = tag;
        this.trigger = trigger;
    }

    public static void init() {
        for (Triggers trigger : VALUES) {
            ActionManager.registerTrigger(trigger);
        }
    }

    @Override
    public String getUniqueTag() {
        return "railcraft." + this.tag;
    }

    @Override
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public boolean hasParameter() {
        return false;
    }

    @Override
    public boolean requiresParameter() {
        return false;
    }

    @Override
    public String getDescription() {
        return RailcraftLanguage.translate("gates.trigger." + this.tag);
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        return this.trigger.isTriggerActive(side, tile, parameter);
    }

    @Override
    public ITriggerParameter createParameter() {
        return new TriggerParameter();
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("railcraft:buildcraft.gate.trigger." + this.tag);
    }

    static {
        VALUES = Triggers.values();
    }
}

