/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;

public class ItemTicket
extends ItemRailcraft {
    public static final IStackFilter FILTER = new IStackFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return stack != null && stack.func_77973_b() instanceof ItemTicket;
        }
    };
    public static final int LINE_LENGTH = 32;
    public static ItemTicket item;

    public static void registerItem() {
        String tag;
        if (item == null && RailcraftConfig.isItemEnabled(tag = "railcraft.routing.ticket")) {
            item = new ItemTicket();
            item.func_77655_b(tag);
            RailcraftLanguage.instance().registerItemName((Object)item, tag);
            ItemRegistry.registerItem(item);
            ItemRegistry.registerItemStack(tag, new ItemStack((Item)item));
        }
    }

    public static ItemStack getTicket() {
        if (item == null) {
            return null;
        }
        return new ItemStack((Item)item);
    }

    public static boolean isNBTValid(NBTTagCompound nbt) {
        if (nbt == null) {
            return false;
        }
        if (!nbt.func_74764_b("dest")) {
            return false;
        }
        NBTTagString dest = (NBTTagString)nbt.func_74781_a("dest");
        if (dest.func_150285_a_() == null) {
            return false;
        }
        return dest.func_150285_a_().length() <= 32;
    }

    public static ItemStack copyTicket(ItemStack source) {
        if (item == null) {
            return null;
        }
        if (source == null) {
            return null;
        }
        if (source.func_77973_b() instanceof ItemTicket) {
            ItemStack ticket = ItemTicket.getTicket();
            NBTTagCompound nbt = source.func_77978_p();
            if (nbt != null) {
                ticket.func_77982_d((NBTTagCompound)nbt.func_74737_b());
            }
            return ticket;
        }
        return null;
    }

    public static boolean setTicketData(ItemStack ticket, String dest, String title, String owner) {
        if (ticket == null || !(ticket.func_77973_b() instanceof ItemTicket)) {
            return false;
        }
        if (dest.length() > 32) {
            return false;
        }
        if (owner == null || owner.equals("")) {
            return false;
        }
        NBTTagCompound data = InvTools.getItemData(ticket);
        data.func_74778_a("dest", dest);
        data.func_74778_a("title", title);
        data.func_74778_a("owner", owner);
        return true;
    }

    public static String getDestination(ItemStack ticket) {
        if (ticket == null || !(ticket.func_77973_b() instanceof ItemTicket)) {
            return "";
        }
        NBTTagCompound nbt = ticket.func_77978_p();
        if (nbt == null) {
            return "";
        }
        return nbt.func_74779_i("dest");
    }

    public static boolean matchesOwnerOrOp(ItemStack ticket, String username) {
        if (!(item instanceof ItemTicket)) {
            return false;
        }
        return MiscTools.isOwnerOrOp(ItemTicket.getOwner(ticket), username);
    }

    public static String getOwner(ItemStack ticket) {
        if (ticket == null || !(ticket.func_77973_b() instanceof ItemTicket)) {
            return "";
        }
        NBTTagCompound nbt = ticket.func_77978_p();
        if (nbt == null) {
            return "";
        }
        return nbt.func_74779_i("owner");
    }

    public boolean validateNBT(NBTTagCompound nbt) {
        String dest = nbt.func_74779_i("dest");
        return dest.length() < 32;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:ticket");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        if (stack.func_77942_o()) {
            String dest;
            String owner = ItemTicket.getOwner(stack);
            if (!owner.equals("")) {
                list.add(EnumChatFormatting.WHITE + RailcraftLanguage.translate("routing.ticket.tip.issuer"));
                list.add(EnumChatFormatting.GRAY + owner);
            }
            if (!(dest = ItemTicket.getDestination(stack)).equals("")) {
                list.add(EnumChatFormatting.WHITE + RailcraftLanguage.translate("routing.ticket.tip.dest"));
                list.add(EnumChatFormatting.GRAY + dest);
            }
        } else {
            list.add(RailcraftLanguage.translate("routing.ticket.tip.blank"));
        }
    }
}

