/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import buildcraft.api.tools.IToolWrench;
import ic2.api.item.IBoxable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.HarvestPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemCrowbar
extends ItemTool
implements IToolCrowbar,
IBoxable,
IToolWrench {
    public static final byte BOOST_DAMAGE = 3;
    private static final String ITEM_TAG = "railcraft.tool.crowbar";
    private static Item item;
    private final Set<Class<? extends Block>> shiftRotations = new HashSet<Class<? extends Block>>();
    private final Set<Class<? extends Block>> bannedRotations = new HashSet<Class<? extends Block>>();

    public static void registerItem() {
        if (item == null && RailcraftConfig.isItemEnabled(ITEM_TAG)) {
            item = new ItemCrowbar(Item.ToolMaterial.IRON);
            item.func_77655_b(ITEM_TAG);
            ItemRegistry.registerItem(item);
            HarvestPlugin.setToolClass(item, "crowbar", 0);
            RailcraftLanguage.instance().registerItemName(item, ITEM_TAG);
            CraftingPlugin.addShapedOreRecipe(new ItemStack(item), " RI", "RIR", "IR ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('R'), "dyeRed");
            LootPlugin.addLootTool(new ItemStack(item), 1, 1, ITEM_TAG);
            ItemRegistry.registerItemStack(ITEM_TAG, new ItemStack(item));
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack(item);
    }

    protected ItemCrowbar(Item.ToolMaterial material) {
        super(3.0f, material, new HashSet<Block>(Arrays.asList(Blocks.field_150448_aq, Blocks.field_150319_E, Blocks.field_150318_D, Blocks.field_150408_cc)));
        this.func_77637_a(CreativePlugin.RAILCRAFT_TAB);
        this.shiftRotations.add(BlockLever.class);
        this.shiftRotations.add(BlockButton.class);
        this.shiftRotations.add(BlockChest.class);
        this.bannedRotations.add(BlockRailBase.class);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:" + MiscTools.cleanTag(this.func_77658_a()));
    }

    private boolean isShiftRotation(Class<? extends Block> cls) {
        for (Class<? extends Block> shift : this.shiftRotations) {
            if (!shift.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    private boolean isBannedRotation(Class<? extends Block> cls) {
        for (Class<? extends Block> banned : this.bannedRotations) {
            if (!banned.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return false;
        }
        if (player.func_70093_af() != this.isShiftRotation(block.getClass())) {
            return false;
        }
        if (this.isBannedRotation(block.getClass())) {
            return false;
        }
        if (block.rotateBlock(world, x, y, z, ForgeDirection.getOrientation((int)side))) {
            player.func_71038_i();
            return !world.field_72995_K;
        }
        return false;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    @Override
    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        return true;
    }

    @Override
    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
        player.func_71045_bC().func_77972_a(1, (EntityLivingBase)player);
        player.func_71038_i();
    }

    @Override
    public boolean canWhack(EntityPlayer player, ItemStack crowbar, int x, int y, int z) {
        return true;
    }

    @Override
    public void onWhack(EntityPlayer player, ItemStack crowbar, int x, int y, int z) {
        crowbar.func_77972_a(1, (EntityLivingBase)player);
        player.func_71038_i();
    }

    @Override
    public boolean canLink(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        return player.func_70093_af();
    }

    @Override
    public void onLink(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        crowbar.func_77972_a(1, (EntityLivingBase)player);
        player.func_71038_i();
    }

    @Override
    public boolean canBoost(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        return !player.func_70093_af();
    }

    @Override
    public void onBoost(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        crowbar.func_77972_a(3, (EntityLivingBase)player);
        player.func_71038_i();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean advInfo) {
        info.add(RailcraftLanguage.translate("gui.tip.crowbar.link"));
    }
}

