/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.widgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.client.emblems.EmblemPackageManager;
import mods.railcraft.client.emblems.EmblemTexture;
import mods.railcraft.client.gui.GuiContainerRailcraft;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.gui.tooltips.ToolTipLine;
import mods.railcraft.common.gui.widgets.Widget;
import net.minecraft.item.EnumRarity;

public class EmblemSlotWidget
extends Widget {
    public String emblemIdentifier;
    private final ToolTip toolTip = new ToolTip(750);

    public EmblemSlotWidget(int x, int y, int u, int v) {
        super(x, y, u, v, 16, 16);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiContainerRailcraft gui, int guiX, int guiY, int mouseX, int mouseY) {
        String emblem = this.getEmblem();
        if (emblem != null && !emblem.equals("")) {
            EmblemTexture emblemTexture = EmblemPackageManager.getEmblemTexture(emblem);
            gui.bindTexture(emblemTexture.getLocation());
            gui.drawTexture(guiX + this.x, guiY + this.y, 16, 16, 0.0f, 0.0f, 1.0f, 1.0f);
            gui.bindTexture(gui.texture);
        }
        if (this.isMouseOver(mouseX, mouseY)) {
            gui.func_73733_a(guiX + this.x, guiY + this.y, guiX + this.x + 16, guiY + this.y + 16, -2130706433, -2130706433);
        }
    }

    protected String getEmblem() {
        return this.emblemIdentifier;
    }

    @Override
    public ToolTip getToolTip() {
        this.toolTip.clear();
        String emblemIdent = this.getEmblem();
        if (emblemIdent == null || emblemIdent.equals("")) {
            return null;
        }
        EmblemPackageManager.Emblem emblem = EmblemPackageManager.getEmblem(emblemIdent);
        if (emblem == null) {
            return null;
        }
        this.toolTip.add(new ToolTipLine(emblem.displayName, EnumRarity.values()[emblem.rarity].field_77937_e));
        return this.toolTip;
    }
}

