/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.blocks.tracks.TrackRouting;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotSecure;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.items.ItemTicketGold;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerTrackRouting
extends RailcraftContainer {
    private final TrackRouting track;
    private final InventoryPlayer playerInv;
    private int lastLockState;
    public String owner = "[Unknown]";
    public boolean canLock = false;
    private SlotSecure slotTicket;

    public ContainerTrackRouting(InventoryPlayer playerInv, TrackRouting track) {
        super(track.getInventory());
        this.track = track;
        this.playerInv = playerInv;
        this.slotTicket = new SlotSecure(ItemTicketGold.FILTER, track.getInventory(), 0, 44, 24);
        this.slotTicket.setToolTips(ToolTip.buildToolTip("routing.track.tip.slot", new String[0]));
        this.addSlot(this.slotTicket);
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)playerInv, k + i * 9 + 9, 8 + k * 18, 58 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)playerInv, j, 8 + j * 18, 116));
        }
    }

    @Override
    public void func_75132_a(ICrafting icrafting) {
        super.func_75132_a(icrafting);
        icrafting.func_71112_a((Container)this, 0, this.track.getLockController().getCurrentState());
        this.canLock = MiscTools.isOwnerOrOp(this.track.getOwner(), this.playerInv.field_70458_d);
        this.slotTicket.locked = this.track.isSecure() && !this.canLock;
        icrafting.func_71112_a((Container)this, 2, this.canLock ? 1 : 0);
        PacketBuilder.instance().sendGuiStringPacket((EntityPlayerMP)icrafting, this.field_75152_c, 0, this.track.getOwner());
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        for (int var1 = 0; var1 < this.field_75149_d.size(); ++var1) {
            ICrafting var2 = (ICrafting)this.field_75149_d.get(var1);
            int lock = this.track.getLockController().getCurrentState();
            if (this.lastLockState == lock) continue;
            var2.func_71112_a((Container)this, 0, lock);
        }
        this.lastLockState = this.track.getLockController().getCurrentState();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        switch (id) {
            case 0: {
                this.track.getLockController().setCurrentState(value);
                break;
            }
            case 2: {
                this.canLock = value == 1;
            }
        }
        this.slotTicket.locked = this.track.isSecure() && !this.canLock;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateString(byte id, String data) {
        switch (id) {
            case 0: {
                this.owner = data;
            }
        }
    }
}

