/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.EntityLocomotiveSteamSolid;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotFuel;
import mods.railcraft.common.gui.slots.SlotOutput;
import mods.railcraft.common.gui.slots.SlotStackFilter;
import mods.railcraft.common.gui.slots.SlotUntouchable;
import mods.railcraft.common.gui.slots.SlotWaterLimited;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.gui.widgets.FluidGaugeWidget;
import mods.railcraft.common.gui.widgets.IndicatorWidget;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerLocomotiveSteamSolid
extends RailcraftContainer {
    private final EntityLocomotiveSteamSolid loco;
    private final InventoryPlayer playerInv;
    private double lastBurnTime;
    private double lastItemBurnTime;
    private double lastHeat;
    private EntityLocomotive.LocoSpeed lastSpeed;
    private EntityLocomotive.LocoMode lastMode;
    private int lastLockState;
    public String owner = "[Unknown]";

    public ContainerLocomotiveSteamSolid(InventoryPlayer playerInv, EntityLocomotiveSteamSolid loco) {
        super((IInventory)loco);
        this.loco = loco;
        this.playerInv = playerInv;
        this.addWidget(new FluidGaugeWidget(loco.getTankManager().get(0), 116, 23, 176, 0, 16, 47));
        this.addWidget(new FluidGaugeWidget(loco.getTankManager().get(1), 17, 23, 176, 0, 16, 47));
        this.addWidget(new IndicatorWidget(loco.boiler.heatIndicator, 40, 25, 176, 61, 6, 43));
        this.addSlot(new SlotWaterLimited((IInventory)loco, 0, 143, 21));
        this.addSlot(new SlotOutput((IInventory)loco, 1, 143, 56));
        this.addSlot(new SlotFuel((IInventory)loco, 2, 62, 39));
        this.addSlot(new SlotFuel((IInventory)loco, 3, 89, 20));
        this.addSlot(new SlotFuel((IInventory)loco, 4, 89, 38));
        this.addSlot(new SlotFuel((IInventory)loco, 5, 89, 56));
        SlotStackFilter slotTicket = new SlotStackFilter(ItemTicket.FILTER, (IInventory)loco, 6, 116, 94);
        slotTicket.setToolTips(ToolTip.buildToolTip("gui.locomotive.tip.slot.ticket", new String[0]));
        this.addSlot(slotTicket);
        this.addSlot(new SlotUntouchable((IInventory)loco, 7, 134, 94));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)playerInv, k + i * 9 + 9, 8 + k * 18, 123 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)playerInv, j, 8 + j * 18, 181));
        }
    }

    @Override
    public void func_75132_a(ICrafting icrafting) {
        super.func_75132_a(icrafting);
        TankManager tMan = this.loco.getTankManager();
        if (tMan != null) {
            tMan.initGuiData(this, icrafting, 0);
            tMan.initGuiData(this, icrafting, 1);
        }
        icrafting.func_71112_a((Container)this, 10, (int)Math.round(this.loco.boiler.burnTime));
        icrafting.func_71112_a((Container)this, 11, (int)Math.round(this.loco.boiler.currentItemBurnTime));
        icrafting.func_71112_a((Container)this, 12, (int)Math.round(this.loco.boiler.getHeat()));
        icrafting.func_71112_a((Container)this, 13, this.loco.getSpeed().ordinal());
        icrafting.func_71112_a((Container)this, 14, this.loco.getMode().ordinal());
        icrafting.func_71112_a((Container)this, 15, this.loco.getLockController().getCurrentState());
        icrafting.func_71112_a((Container)this, 16, MiscTools.isOwnerOrOp(this.loco.getOwner(), this.playerInv.field_70458_d) ? 1 : 0);
        PacketBuilder.instance().sendGuiStringPacket((EntityPlayerMP)icrafting, this.field_75152_c, 0, this.loco.getOwner());
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        TankManager tMan = this.loco.getTankManager();
        if (tMan != null) {
            tMan.updateGuiData(this, this.field_75149_d, 0);
            tMan.updateGuiData(this, this.field_75149_d, 1);
        }
        for (int var1 = 0; var1 < this.field_75149_d.size(); ++var1) {
            int lock;
            EntityLocomotive.LocoMode mode;
            EntityLocomotive.LocoSpeed speed;
            ICrafting var2 = (ICrafting)this.field_75149_d.get(var1);
            if (this.lastBurnTime != this.loco.boiler.burnTime) {
                var2.func_71112_a((Container)this, 10, (int)Math.round(this.loco.boiler.burnTime));
            }
            if (this.lastItemBurnTime != this.loco.boiler.currentItemBurnTime) {
                var2.func_71112_a((Container)this, 11, (int)Math.round(this.loco.boiler.currentItemBurnTime));
            }
            if (this.lastHeat != this.loco.boiler.getHeat()) {
                var2.func_71112_a((Container)this, 12, (int)Math.round(this.loco.boiler.getHeat()));
            }
            if (this.lastSpeed != (speed = this.loco.getSpeed())) {
                var2.func_71112_a((Container)this, 13, speed.ordinal());
            }
            if (this.lastMode != (mode = this.loco.getMode())) {
                var2.func_71112_a((Container)this, 14, mode.ordinal());
            }
            if (this.lastLockState == (lock = this.loco.getLockController().getCurrentState())) continue;
            var2.func_71112_a((Container)this, 15, lock);
        }
        this.lastBurnTime = this.loco.boiler.burnTime;
        this.lastItemBurnTime = this.loco.boiler.currentItemBurnTime;
        this.lastHeat = this.loco.boiler.getHeat();
        this.lastSpeed = this.loco.getSpeed();
        this.lastMode = this.loco.getMode();
        this.lastLockState = this.loco.getLockController().getCurrentState();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        TankManager tMan = this.loco.getTankManager();
        if (tMan != null) {
            tMan.processGuiUpdate(id, value);
        }
        switch (id) {
            case 10: {
                this.loco.boiler.burnTime = value;
                break;
            }
            case 11: {
                this.loco.boiler.currentItemBurnTime = value;
                break;
            }
            case 12: {
                this.loco.boiler.setHeat(value);
                break;
            }
            case 13: {
                this.loco.clientSpeed = EntityLocomotive.LocoSpeed.VALUES[value];
                break;
            }
            case 14: {
                this.loco.clientMode = EntityLocomotive.LocoMode.VALUES[value];
                break;
            }
            case 15: {
                this.loco.getLockController().setCurrentState(value);
                break;
            }
            case 16: {
                this.loco.clientCanLock = value == 1;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateString(byte id, String data) {
        switch (id) {
            case 0: {
                this.owner = data;
            }
        }
    }
}

