/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.emblems;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.client.emblems.EmblemPackageManager;
import mods.railcraft.common.items.ItemRailcraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;

public abstract class ItemEmblemBase
extends ItemRailcraft {
    public static String getEmblemIdentifier(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            NBTTagString emblemIdent = (NBTTagString)nbt.func_74781_a("emblem");
            return emblemIdent != null ? emblemIdent.func_150285_a_() : "";
        }
        return "";
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            NBTTagString emblemIdent = (NBTTagString)nbt.func_74781_a("emblem");
            if (emblemIdent == null) {
                return;
            }
            EmblemPackageManager.Emblem emblem = EmblemPackageManager.getEmblemOrLoad(emblemIdent.func_150285_a_());
            if (emblem != null) {
                info.add(EnumChatFormatting.GRAY + emblem.displayName);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        EnumRarity rarity = EnumRarity.common;
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            NBTTagString emblemIdent = (NBTTagString)nbt.func_74781_a("emblem");
            if (emblemIdent == null) {
                return rarity;
            }
            EmblemPackageManager.Emblem emblem = EmblemPackageManager.getEmblemOrLoad(emblemIdent.func_150285_a_());
            if (emblem == null) {
                return EnumRarity.common;
            }
            rarity = EnumRarity.values()[emblem.rarity];
        }
        return rarity;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        if (pass != 0) {
            return false;
        }
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            NBTTagString emblemIdent = (NBTTagString)nbt.func_74781_a("emblem");
            if (emblemIdent == null) {
                return false;
            }
            EmblemPackageManager.Emblem emblem = EmblemPackageManager.getEmblemOrLoad(emblemIdent.func_150285_a_());
            return emblem != null && emblem.hasEffect;
        }
        return false;
    }
}

