/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.emblems;

import com.google.common.io.BaseEncoding;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import mods.railcraft.common.emblems.EmblemUnlocker;
import mods.railcraft.common.plugins.forge.NBTPlugin;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.commons.lang3.ArrayUtils;

public class EmblemManager {
    public static final String EMBLEM_NBT_DATA = "emblemData";
    public static final String EMBLEM_UNLOCK_NBT_DATA = "unlocks";
    private static final BaseEncoding encoder = BaseEncoding.base32().omitPadding().lowerCase();
    private static final Set<String> starterEmblems;

    public static boolean playerHasEmblem(EntityPlayer player, String emblem) {
        Set<String> emblems = EmblemManager.getUnlockedEmblems(player);
        return emblems.contains(emblem);
    }

    private static NBTTagCompound getEmblemData(EntityPlayer player) {
        NBTTagCompound railcraftData;
        NBTTagCompound persistantData;
        NBTTagCompound forgeData = player.getEntityData();
        if (!forgeData.func_74764_b("PlayerPersisted")) {
            forgeData.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        if (!(persistantData = forgeData.func_74775_l("PlayerPersisted")).func_74764_b("railcraftData")) {
            persistantData.func_74782_a("railcraftData", (NBTBase)new NBTTagCompound());
        }
        if (!(railcraftData = persistantData.func_74775_l("railcraftData")).func_74764_b(EMBLEM_NBT_DATA)) {
            railcraftData.func_74782_a(EMBLEM_NBT_DATA, (NBTBase)new NBTTagCompound());
        }
        return railcraftData.func_74775_l(EMBLEM_NBT_DATA);
    }

    private static NBTPlugin.NBTList<NBTTagByteArray> getEmblemUnlockData(EntityPlayer player) {
        NBTTagCompound emblemData = EmblemManager.getEmblemData(player);
        if (!emblemData.func_74764_b(EMBLEM_UNLOCK_NBT_DATA)) {
            emblemData.func_74782_a(EMBLEM_UNLOCK_NBT_DATA, (NBTBase)new NBTTagList());
        }
        return NBTPlugin.getNBTList(emblemData, EMBLEM_UNLOCK_NBT_DATA, NBTPlugin.EnumNBTType.BYTE_ARRAY);
    }

    public static Set<String> getUnlockedEmblems(EntityPlayer player) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(starterEmblems);
        NBTPlugin.NBTList<NBTTagByteArray> unlocks = EmblemManager.getEmblemUnlockData(player);
        Iterator i$ = unlocks.iterator();
        while (i$.hasNext()) {
            NBTTagByteArray tag = (NBTTagByteArray)i$.next();
            set.add(EmblemManager.unscrambleIdentifier(tag.func_150292_c()));
        }
        return set;
    }

    static void unlockEmblem(EntityPlayerMP player, String emblemCode) {
        String identifier = EmblemManager.getIdentifierFromCode(emblemCode);
        if (EmblemManager.getUnlockedEmblems((EntityPlayer)player).contains(identifier)) {
            return;
        }
        NBTPlugin.NBTList<NBTTagByteArray> unlocks = EmblemManager.getEmblemUnlockData((EntityPlayer)player);
        unlocks.add(new NBTTagByteArray(EmblemManager.scrambleIdentifier(identifier)));
    }

    public static void unlockEmblem(EntityPlayerMP player, String emblemCode, int windowId) {
        String identifier = EmblemManager.getIdentifierFromCode(emblemCode);
        if (EmblemManager.playerHasEmblem((EntityPlayer)player, emblemCode)) {
            EmblemManager.updateUnlockGUI(player, identifier, windowId, "gui.engrave.unlock.exists");
            return;
        }
        EmblemUnlocker.spawnUnlocker(emblemCode, windowId, player);
    }

    public static void updateUnlockGUI(EntityPlayerMP player, String identifier, int windowId, String msg) {
        PacketBuilder.instance().sendGuiStringPacket(player, windowId, 0, identifier);
        PacketBuilder.instance().sendGuiStringPacket(player, windowId, 1, msg);
    }

    public static String getIdentifierFromCode(String unlockCode) {
        try {
            MessageDigest msgDigest = MessageDigest.getInstance("SHA-1");
            msgDigest.update(unlockCode.getBytes("UTF-8"));
            byte[] rawByte = msgDigest.digest();
            return encoder.encode(rawByte);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static byte[] scrambleIdentifier(String identifier) {
        byte[] bytes = encoder.decode((CharSequence)identifier);
        bytes = Arrays.copyOf(bytes, bytes.length);
        ArrayUtils.reverse((byte[])bytes);
        return bytes;
    }

    public static String unscrambleIdentifier(byte[] bytes) {
        bytes = Arrays.copyOf(bytes, bytes.length);
        ArrayUtils.reverse((byte[])bytes);
        return encoder.encode(bytes);
    }

    static {
        LinkedHashSet<String> starters = new LinkedHashSet<String>();
        starters.add(EmblemManager.getIdentifierFromCode("Railcraft"));
        starters.add(EmblemManager.getIdentifierFromCode("Book"));
        starters.add(EmblemManager.getIdentifierFromCode("Stone Age Miner"));
        starters.add(EmblemManager.getIdentifierFromCode("Toy Sword"));
        starters.add(EmblemManager.getIdentifierFromCode("Bone Dead"));
        starters.add(EmblemManager.getIdentifierFromCode("All Aboard"));
        starters.add(EmblemManager.getIdentifierFromCode("Record Breaker"));
        starters.add(EmblemManager.getIdentifierFromCode("Sleeper"));
        starters.add(EmblemManager.getIdentifierFromCode("It's a lie!"));
        starters.add(EmblemManager.getIdentifierFromCode("Beauty"));
        starters.add(EmblemManager.getIdentifierFromCode("Power Up"));
        starters.add(EmblemManager.getIdentifierFromCode("ssssSS!"));
        starters.add(EmblemManager.getIdentifierFromCode("Sticky Situation"));
        starters.add(EmblemManager.getIdentifierFromCode("Sticky Situation"));
        starters.add(EmblemManager.getIdentifierFromCode("my name is jack"));
        starters.add(EmblemManager.getIdentifierFromCode("tells no tales"));
        starters.add(EmblemManager.getIdentifierFromCode("are you ready for z-day?"));
        starters.add(EmblemManager.getIdentifierFromCode("no acorns here"));
        starterEmblems = Collections.unmodifiableSet(starters);
    }
}

