/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.LinkageManager;
import net.minecraft.entity.item.EntityMinecart;

public class Train
implements Iterable<EntityMinecart> {
    private final UUID uuid;
    private final Set<UUID> carts = new HashSet<UUID>();
    private final Set<UUID> safeSet = Collections.unmodifiableSet(this.carts);
    private final Set<UUID> lockingTracks = new HashSet<UUID>();
    private final Set<UUID> frontback = new HashSet<UUID>();
    private TrainState trainState = TrainState.NORMAL;

    public Train(EntityMinecart cart) {
        this.uuid = UUID.randomUUID();
        this.addCartsToTrain(cart);
    }

    @Override
    public Iterator<EntityMinecart> iterator() {
        return new Iterator<EntityMinecart>(){
            private final Iterator<UUID> it;
            private final LinkageManager lm;
            {
                this.it = Train.this.carts.iterator();
                this.lm = LinkageManager.instance();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public EntityMinecart next() {
                return this.lm.getCartFromLinkageId(this.it.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing not supported.");
            }
        };
    }

    public Iterable<EntityMinecart> orderedIteratable(final EntityMinecart head) {
        return new Iterable<EntityMinecart>(){

            @Override
            public Iterator<EntityMinecart> iterator() {
                return new Iterator<EntityMinecart>(){
                    private final LinkageManager lm = LinkageManager.instance();
                    private EntityMinecart last = null;
                    private EntityMinecart current;
                    {
                        this.current = head;
                    }

                    @Override
                    public boolean hasNext() {
                        EntityMinecart next = this.lm.getLinkedCartA(this.current);
                        if (next != null && next != this.last) {
                            return true;
                        }
                        next = this.lm.getLinkedCartB(this.current);
                        return next != null && next != this.last;
                    }

                    @Override
                    public EntityMinecart next() {
                        EntityMinecart next = this.lm.getLinkedCartA(this.current);
                        if (next != this.last) {
                            this.last = this.current;
                            this.current = next;
                            return this.current;
                        }
                        next = this.lm.getLinkedCartB(this.current);
                        if (next != this.last) {
                            this.last = this.current;
                            this.current = next;
                            return this.current;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removing not supported.");
                    }
                };
            }
        };
    }

    private void addCartsToTrain(EntityMinecart cart) {
        this.addCart(cart);
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart linkA = lm.getLinkedCartA(cart);
        EntityMinecart linkB = lm.getLinkedCartB(cart);
        if (linkA == null) {
            this.frontback.add(cart.getPersistentID());
        } else if (!this.containsCart(linkA)) {
            this.addCartsToTrain(linkA);
        }
        if (linkB == null) {
            this.frontback.add(cart.getPersistentID());
        } else if (!this.containsCart(linkB)) {
            this.addCartsToTrain(linkB);
        }
    }

    protected void releaseTrain() {
        LinkageManager lm = LinkageManager.instance();
        for (UUID id : this.carts) {
            EntityMinecart cart = lm.getCartFromLinkageId(id);
            if (cart == null) continue;
            cart.getEntityData().func_82580_o("rcTrainHigh");
            cart.getEntityData().func_82580_o("rcTrainLow");
        }
        this.carts.clear();
        this.lockingTracks.clear();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    private void addCart(EntityMinecart cart) {
        this.carts.add(cart.getPersistentID());
        cart.getEntityData().func_74772_a("rcTrainHigh", this.uuid.getMostSignificantBits());
        cart.getEntityData().func_74772_a("rcTrainLow", this.uuid.getLeastSignificantBits());
    }

    public boolean containsCart(EntityMinecart cart) {
        if (cart == null) {
            return false;
        }
        return this.carts.contains(cart.getPersistentID());
    }

    public boolean isTrainEnd(EntityMinecart cart) {
        if (cart == null) {
            return false;
        }
        return this.frontback.contains(cart.getPersistentID());
    }

    public EntityLocomotive getLocomotive() {
        LinkageManager lm = LinkageManager.instance();
        for (UUID id : this.frontback) {
            EntityMinecart cart = lm.getCartFromLinkageId(id);
            if (!(cart instanceof EntityLocomotive)) continue;
            return (EntityLocomotive)cart;
        }
        return null;
    }

    public Set<UUID> getCartsInTrain() {
        return this.safeSet;
    }

    public int size() {
        return this.carts.size();
    }

    public boolean isTrainLockedDown() {
        return !this.lockingTracks.isEmpty();
    }

    public void addLockingTrack(UUID track) {
        this.lockingTracks.add(track);
    }

    public void removeLockingTrack(UUID track) {
        this.lockingTracks.remove(track);
    }

    public boolean isIdle() {
        return this.trainState == TrainState.IDLE || this.isTrainLockedDown();
    }

    public boolean isStopped() {
        return this.trainState == TrainState.STOPPED;
    }

    public void setTrainState(TrainState state) {
        this.trainState = state;
    }

    public static Train getTrain(EntityMinecart cart) {
        if (cart == null) {
            return null;
        }
        LinkageManager lm = LinkageManager.instance();
        return lm.getTrain(cart);
    }

    public static enum TrainState {
        STOPPED,
        IDLE,
        NORMAL;

    }
}

