/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import cpw.mods.fml.common.registry.EntityRegistry;
import java.lang.reflect.Constructor;
import java.util.Locale;
import mods.railcraft.api.carts.locomotive.LocomotiveRenderType;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.carts.EntityCartAnchor;
import mods.railcraft.common.carts.EntityCartAnchorAdmin;
import mods.railcraft.common.carts.EntityCartAnchorPersonal;
import mods.railcraft.common.carts.EntityCartBasic;
import mods.railcraft.common.carts.EntityCartChest;
import mods.railcraft.common.carts.EntityCartEnergyBatBox;
import mods.railcraft.common.carts.EntityCartEnergyCESU;
import mods.railcraft.common.carts.EntityCartEnergyMFE;
import mods.railcraft.common.carts.EntityCartFurnace;
import mods.railcraft.common.carts.EntityCartGift;
import mods.railcraft.common.carts.EntityCartPumpkin;
import mods.railcraft.common.carts.EntityCartTNT;
import mods.railcraft.common.carts.EntityCartTNTWood;
import mods.railcraft.common.carts.EntityCartTank;
import mods.railcraft.common.carts.EntityCartTrackRelayer;
import mods.railcraft.common.carts.EntityCartUndercutter;
import mods.railcraft.common.carts.EntityCartWork;
import mods.railcraft.common.carts.EntityLocomotiveSteamMagic;
import mods.railcraft.common.carts.EntityLocomotiveSteamSolid;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.carts.IRailcraftCart;
import mods.railcraft.common.carts.ItemCart;
import mods.railcraft.common.carts.ItemCartAnchor;
import mods.railcraft.common.carts.ItemLocomotive;
import mods.railcraft.common.carts.ItemTunnelBore;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.EntityIDs;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public enum EnumCart {
    BASIC(0, EntityCartBasic.class, null),
    CHEST(0, EntityCartChest.class, new ItemStack((Block)Blocks.field_150486_ae)),
    FURNACE(0, EntityCartFurnace.class, new ItemStack(Blocks.field_150460_al)),
    TNT_WOOD(0, EntityCartTNTWood.class, new ItemStack(Blocks.field_150335_W)),
    TANK(0, EntityCartTank.class, null),
    ANCHOR(0, EntityCartAnchor.class, null),
    WORK(0, EntityCartWork.class, new ItemStack(Blocks.field_150462_ai)),
    TRACK_RELAYER(1, EntityCartTrackRelayer.class, null),
    UNDERCUTTER(1, EntityCartUndercutter.class, null),
    PUMPKIN(3, EntityCartPumpkin.class, new ItemStack(Blocks.field_150423_aK)),
    GIFT(3, EntityCartGift.class, null),
    ANCHOR_PERSONAL(0, EntityCartAnchorPersonal.class, null),
    ANCHOR_ADMIN(3, EntityCartAnchorAdmin.class, null),
    TNT(0, EntityCartTNT.class, new ItemStack(Blocks.field_150335_W)),
    LOCO_STEAM_SOLID(1, EntityLocomotiveSteamSolid.class, null),
    LOCO_STEAM_MAGIC(1, EntityLocomotiveSteamMagic.class, null),
    BORE(1, EntityTunnelBore.class, null),
    ENERGY_BATBOX(0, EntityCartEnergyBatBox.class, null),
    ENERGY_CESU(0, EntityCartEnergyCESU.class, null),
    ENERGY_MFE(0, EntityCartEnergyMFE.class, null);

    public static final EnumCart[] VALUES;
    private final Class<? extends EntityMinecart> type;
    private final byte id;
    private final byte rarity;
    private ItemStack contents = null;
    private ItemStack cartItem;

    private EnumCart(int rarity, Class<? extends EntityMinecart> type, ItemStack contents) {
        int entityId = -1;
        try {
            entityId = (byte)EntityIDs.class.getField("CART_" + this.name()).getInt(null);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.id = (byte)entityId;
        this.rarity = (byte)rarity;
        this.type = type;
        this.contents = contents;
    }

    public byte getId() {
        return this.id;
    }

    public String getTag() {
        return "railcraft.cart." + this.name().toLowerCase(Locale.ENGLISH).replace('_', '.');
    }

    public Class<? extends EntityMinecart> getCartClass() {
        return this.type;
    }

    public void setContents(ItemStack stack) {
        this.contents = stack.func_77946_l();
    }

    public ItemStack getContents() {
        switch (this) {
            case TANK: {
                if (!EnumMachineBeta.TANK_IRON_GAUGE.isAvaliable()) break;
                return EnumMachineBeta.TANK_IRON_GAUGE.getItem();
            }
        }
        if (this.contents == null) {
            return null;
        }
        return this.contents.func_77946_l();
    }

    public EntityMinecart makeCart(ItemStack stack, World world, double i, double j, double k) {
        try {
            Constructor<? extends EntityMinecart> con = this.type.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE);
            EntityMinecart entity = con.newInstance(world, i, j, k);
            if (entity instanceof IRailcraftCart) {
                ((IRailcraftCart)entity).initEntityFromItem(stack);
            }
            return entity;
        }
        catch (Throwable ex) {
            Game.logThrowable("Failed to create cart entity!", ex, new Object[0]);
            return new EntityCartBasic(world, i, j, k);
        }
    }

    public ItemStack getCartItem() {
        if (this.cartItem == null) {
            return null;
        }
        return this.cartItem.func_77946_l();
    }

    public void setCartItem(ItemStack cartItem) {
        this.cartItem = cartItem.func_77946_l();
    }

    private ItemCart defineItem() {
        switch (this) {
            case BORE: {
                return new ItemTunnelBore();
            }
            case LOCO_STEAM_SOLID: {
                return new ItemLocomotive(this, LocomotiveRenderType.STEAM_SOLID);
            }
            case LOCO_STEAM_MAGIC: {
                return new ItemLocomotive(this, LocomotiveRenderType.STEAM_MAGIC);
            }
            case ANCHOR: 
            case ANCHOR_ADMIN: 
            case ANCHOR_PERSONAL: {
                return new ItemCartAnchor(this);
            }
        }
        return new ItemCart(this);
    }

    public void registerEntity() {
        if (this.id < 0) {
            return;
        }
        EntityRegistry.registerModEntity(this.type, (String)MiscTools.cleanTag(this.getTag()), (int)this.id, (Object)Railcraft.getMod(), (int)256, (int)3, (boolean)true);
        EntityList.field_75625_b.put("Railcraft." + this.getTag(), this.type);
        if (this == LOCO_STEAM_SOLID) {
            EntityList.field_75625_b.put("Railcraft.railcraft.cart.loco.steam", this.type);
        }
    }

    public boolean setup() {
        String tag = this.getTag();
        boolean cartEnabled = RailcraftConfig.isCartEnabled(tag);
        if (cartEnabled) {
            this.registerEntity();
            ItemCart item = this.defineItem();
            item.func_77655_b(tag);
            item.setRarity(this.rarity);
            ItemRegistry.registerItem((Item)item);
            ItemStack stack = new ItemStack((Item)item);
            RailcraftLanguage.instance().registerItemName(stack, tag);
            this.setCartItem(stack);
            ItemRegistry.registerItemStack(tag, stack);
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        String tag = this.getTag();
        return RailcraftConfig.isCartEnabled(tag);
    }

    public static EnumCart fromClass(Class<? extends EntityMinecart> cls) {
        for (EnumCart cart : VALUES) {
            if (!cls.equals(cart.type)) continue;
            return cart;
        }
        return BASIC;
    }

    public static EnumCart fromCart(EntityMinecart cart) {
        return EnumCart.fromClass(cart.getClass());
    }

    static {
        VALUES = EnumCart.values();
    }
}

