/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import mods.railcraft.api.carts.locomotive.LocomotiveRenderType;
import mods.railcraft.common.carts.EntityLocomotiveSteam;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.steam.SolidFuelProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class EntityLocomotiveSteamSolid
extends EntityLocomotiveSteam
implements ISidedInventory {
    private static final int SLOT_BURN = 2;
    private static final int SLOT_FUEL_A = 3;
    private static final int SLOT_FUEL_B = 4;
    private static final int SLOT_FUEL_C = 5;
    private static final int SLOT_TICKET = 6;
    private static final int SLOT_DESTINATION = 7;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 7);
    private IInventory invBurn = new InventoryMapper((IInventory)this, 2, 1);
    private IInventory invStock = new InventoryMapper((IInventory)this, 3, 3);
    private IInventory invFuel = new InventoryMapper((IInventory)this, 2, 4);
    private IInventory invTicket = new InventoryMapper((IInventory)this, 6, 2, false);

    public EntityLocomotiveSteamSolid(World world) {
        super(world);
    }

    public EntityLocomotiveSteamSolid(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    public EnumCart getCartType() {
        return EnumCart.LOCO_STEAM_SOLID;
    }

    @Override
    public LocomotiveRenderType getRenderType() {
        return LocomotiveRenderType.STEAM_SOLID;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.boiler.setFuelProvider(new SolidFuelProvider((IInventory)this, 2){

            @Override
            public double getMoreFuel() {
                if (EntityLocomotiveSteamSolid.this.isShutdown()) {
                    return 0.0;
                }
                return super.getMoreFuel();
            }
        });
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (Game.isHost(this.field_70170_p)) {
            InvTools.moveOneItem(this.invStock, this.invBurn);
            InvTools.moveOneItem(this.invBurn, this.invWaterOutput, FluidContainerRegistry.EMPTY_BUCKET);
        }
    }

    @Override
    protected void openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.LOCO_STEAM, player, this.field_70170_p, (Entity)this);
    }

    @Override
    public boolean needsRefuel() {
        FluidStack water = this.tankWater.getFluid();
        if (water == null || water.amount < this.tankWater.getCapacity() / 3) {
            return true;
        }
        int numItems = InvTools.countItems(this.invFuel);
        if (numItems == 0) {
            return true;
        }
        int maxItems = InvTools.countMaxItemStackSize(this.invFuel);
        return (double)numItems / (double)maxItems < 0.25;
    }

    @Override
    protected IInventory getTicketInventory() {
        return this.invTicket;
    }

    @Override
    public int func_70302_i_() {
        return 8;
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot < 6;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return FuelPlugin.getBurnTime(stack) > 0;
            }
            case 0: {
                return FluidHelper.containsFluidStack(stack, Fluids.WATER.get(1));
            }
            case 6: {
                return ItemTicket.FILTER.matches(stack);
            }
        }
        return false;
    }
}

