/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.carts.CartTransferBase;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class EntityCartChest
extends CartTransferBase {
    public EntityCartChest(World world) {
        super(world);
    }

    public EntityCartChest(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ItemStack(Items.field_151143_au));
            items.add(new ItemStack((Block)Blocks.field_150486_ae));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    @Override
    public ItemStack getCartItem() {
        ItemStack stack = new ItemStack(Items.field_151108_aI);
        if (this.func_145818_k_()) {
            stack.func_151001_c(this.func_70005_c_());
        }
        return stack;
    }

    @Override
    public double getDrag() {
        return 0.991999979019165;
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.field_70170_p)) {
            player.func_71007_a((IInventory)this);
        }
        return true;
    }

    @Override
    public int func_94087_l() {
        return 1;
    }

    public Block func_145820_n() {
        return Blocks.field_150486_ae;
    }

    public int func_94085_r() {
        return 8;
    }

    public boolean canBeRidden() {
        return false;
    }

    public int func_70302_i_() {
        return 27;
    }

    public String func_145825_b() {
        return "Chest Cart";
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!RailcraftConfig.chestAllowLiquids()) {
            return this.func_70301_a(slot) == null || !FluidHelper.isContainer(stack);
        }
        return true;
    }
}

