/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.util.List;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackSwitch;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.IRouter;
import mods.railcraft.common.blocks.signals.IRoutingTile;
import mods.railcraft.common.blocks.signals.RoutingLogic;
import mods.railcraft.common.blocks.signals.TileSwitchSecured;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.items.ItemRoutingTable;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSwitchRouting
extends TileSwitchSecured
implements IRouter,
IRoutingTile {
    private RoutingLogic logic;
    private final StandaloneInventory inv = new StandaloneInventory(1, this);
    private final MultiButtonController<IRouter.RoutingButtonState> routingController = new MultiButtonController(0, (IMultiButtonState[])IRouter.RoutingButtonState.values());

    @Override
    public MultiButtonController<IRouter.RoutingButtonState> getRoutingController() {
        return this.routingController;
    }

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.SWITCH_ROUTING;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (Game.isHost(this.field_145850_b)) {
            GuiHandler.openGui(EnumGui.ROUTING, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        InvTools.dropInventory(this.inv, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.field_145850_b)) {
            return;
        }
        this.refreshLogic();
        boolean shouldSwitch = false;
        for (int side = 2; side < 6; side = (int)((byte)(side + 1))) {
            TileEntity tile = this.tileCache.getTileOnSide(ForgeDirection.getOrientation((int)side));
            if (tile instanceof TileTrack) {
                ITrackInstance track = ((TileTrack)tile).getTrackInstance();
                shouldSwitch |= track instanceof ITrackSwitch && this.isRoutedCartApproaching((ITrackSwitch)track);
                continue;
            }
            shouldSwitch |= tile instanceof ITrackSwitch && this.isRoutedCartApproaching((ITrackSwitch)tile);
        }
        this.switchTrack(shouldSwitch);
    }

    private boolean isRoutedCartApproaching(ITrackSwitch track) {
        if (this.logic == null || !this.logic.isValid()) {
            return false;
        }
        AxisAlignedBB searchBox = track.getRoutingSearchBox();
        List<EntityMinecart> carts = CartUtils.getMinecartsIn(this.field_145850_b, searchBox);
        for (EntityMinecart cart : carts) {
            if (!this.logic.matches(this, cart)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        boolean power = this.isBeingPoweredByRedstone();
        if (this.isPowered() != power) {
            this.setPowered(power);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.resetLogic();
    }

    @Override
    public RoutingLogic getLogic() {
        this.refreshLogic();
        return this.logic;
    }

    @Override
    public void resetLogic() {
        this.logic = null;
    }

    private void refreshLogic() {
        if (this.logic == null && this.inv.func_70301_a(0) != null) {
            this.logic = ItemRoutingTable.getLogic(this.inv.func_70301_a(0));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.inv.writeToNBT("inv", data);
        this.routingController.writeToNBT(data, "railwayType");
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.inv.readFromNBT("inv", data);
        this.routingController.readFromNBT(data, "railwayType");
    }

    @Override
    public IInventory getInventory() {
        return this.inv;
    }
}

