/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SimpleSignalController;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.IAspectActionManager;
import mods.railcraft.common.blocks.signals.ISignalBlockTile;
import mods.railcraft.common.blocks.signals.SignalBlock;
import mods.railcraft.common.blocks.signals.SignalBlockRelay;
import mods.railcraft.common.blocks.signals.TileBoxActionManager;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.triggers.IAspectProvider;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.util.ForgeDirection;

public class TileBoxBlockRelay
extends TileBoxActionManager
implements IControllerTile,
ISignalBlockTile,
IAspectActionManager,
IGuiReturnHandler,
IAspectProvider {
    private boolean prevBlinkState;
    private final SimpleSignalController controller = new SimpleSignalController(this.getName(), this);
    private final SignalBlock signalBlock = new SignalBlockRelay(this);

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_BLOCK_RELAY;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (player.func_70093_af()) {
            return false;
        }
        if (Game.isHost(this.field_145850_b)) {
            GuiHandler.openGui(EnumGui.BOX_RELAY, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.field_145850_b)) {
            this.controller.tickClient();
            this.signalBlock.tickClient();
            if (this.clock % 4 == 0 && this.controller.getAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.getX(), this.getY(), this.getZ());
                this.markBlockForUpdate();
            }
            return;
        }
        this.controller.tickServer();
        this.signalBlock.tickServer();
        SignalAspect prevAspect = this.controller.getAspect();
        if (this.controller.isBeingPaired()) {
            this.controller.setAspect(SignalAspect.BLINK_YELLOW);
        } else {
            this.controller.setAspect(this.signalBlock.getSignalAspect());
        }
        if (prevAspect != this.controller.getAspect()) {
            this.updateNeighbors();
            this.sendUpdateToClient();
        }
    }

    private void updateNeighbors() {
        this.notifyBlocksOfNeighborChange();
        for (int side = 2; side < 6; ++side) {
            ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side);
            TileEntity tile = this.tileCache.getTileOnSide(forgeSide);
            if (!(tile instanceof TileBoxBase)) continue;
            TileBoxBase box = (TileBoxBase)tile;
            box.onNeighborStateChange(this, forgeSide);
        }
    }

    @Override
    public int getPowerOutput(int side) {
        TileEntity tile = WorldPlugin.getTileEntityOnSide(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, MiscTools.getOppositeSide(side));
        if (tile instanceof TileBoxBase) {
            return 0;
        }
        return this.isEmitingRedstone(ForgeDirection.getOrientation((int)side)) ? 15 : 0;
    }

    @Override
    public boolean isEmitingRedstone(ForgeDirection side) {
        return this.doesActionOnAspect(this.getBoxSignalAspect(side));
    }

    @Override
    public boolean canEmitingRedstone(ForgeDirection side) {
        return true;
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.signalBlock.writeToNBT(data);
        this.controller.writeToNBT(data);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.signalBlock.readFromNBT(data);
        this.controller.readFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.controller.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.controller.readPacketData(data);
        this.markBlockForUpdate();
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        super.readGuiData(data, sender);
        this.updateNeighbors();
    }

    @Override
    public SimpleSignalController getController() {
        return this.controller;
    }

    @Override
    public SignalBlock getSignalBlock() {
        return this.signalBlock;
    }

    @Override
    public void doActionOnAspect(SignalAspect aspect, boolean trigger) {
        super.doActionOnAspect(aspect, trigger);
        this.updateNeighbors();
    }

    @Override
    public boolean isConnected(ForgeDirection side) {
        TileEntity tile = this.tileCache.getTileOnSide(side);
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canReceiveAspect();
        }
        return false;
    }

    @Override
    public SignalAspect getBoxSignalAspect(ForgeDirection side) {
        return this.controller.getAspect();
    }

    @Override
    public boolean canTransferAspect() {
        return true;
    }

    @Override
    public SignalAspect getTriggerAspect() {
        return this.getBoxSignalAspect(null);
    }
}

