/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.ISignalTile;
import mods.railcraft.common.blocks.signals.MaterialStructure;
import mods.railcraft.common.blocks.signals.TileBoxBlockRelay;
import mods.railcraft.common.blocks.signals.TileBoxCapacitor;
import mods.railcraft.common.blocks.signals.TileBoxController;
import mods.railcraft.common.blocks.signals.TileBoxInterlock;
import mods.railcraft.common.blocks.signals.TileBoxReceiver;
import mods.railcraft.common.blocks.signals.TileBoxSequencer;
import mods.railcraft.common.blocks.signals.TileSignalBlockSignal;
import mods.railcraft.common.blocks.signals.TileSignalDistantSignal;
import mods.railcraft.common.blocks.signals.TileSignalDualHeadBlockSignal;
import mods.railcraft.common.blocks.signals.TileSignalDualHeadDistantSignal;
import mods.railcraft.common.blocks.signals.TileSignalFoundation;
import mods.railcraft.common.blocks.signals.TileSwitchLever;
import mods.railcraft.common.blocks.signals.TileSwitchMotor;
import mods.railcraft.common.blocks.signals.TileSwitchRouting;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public class BlockSignal
extends BlockContainer
implements IPostConnection {
    public static IIcon[] texturesBox;
    public static IIcon[] texturesLampTop;
    public static IIcon[] texturesLampBottom;
    public static IIcon[] texturesLampBox;
    public static IIcon[] texturesSignalSingle;
    public static IIcon[] texturesSignalDual;
    public static IIcon[] texturesSwitch;
    public static IIcon[] texturesSwitchTarget;
    public static IIcon texturesSwitchLever;
    private final int renderType;

    public BlockSignal(int renderType) {
        super((Material)new MaterialStructure());
        this.renderType = renderType;
        this.func_149663_c("railcraft.signal");
        this.func_149672_a(Block.field_149777_j);
        this.func_149752_b(50.0f);
        this.func_149647_a(CreativeTabs.field_78029_e);
        GameRegistry.registerTileEntity(TileBoxController.class, (String)"RCTileStructureControllerBox");
        GameRegistry.registerTileEntity(TileBoxReceiver.class, (String)"RCTileStructureReceiverBox");
        GameRegistry.registerTileEntity(TileBoxCapacitor.class, (String)"RCTileStructureCapacitorBox");
        GameRegistry.registerTileEntity(TileBoxBlockRelay.class, (String)"RCTileStructureSignalBox");
        GameRegistry.registerTileEntity(TileBoxSequencer.class, (String)"RCTileStructureSequencerBox");
        GameRegistry.registerTileEntity(TileBoxInterlock.class, (String)"RCTileStructureInterlockBox");
        GameRegistry.registerTileEntity(TileSwitchMotor.class, (String)"RCTileStructureSwitchMotor");
        GameRegistry.registerTileEntity(TileSwitchLever.class, (String)"RCTileStructureSwitchLever");
        GameRegistry.registerTileEntity(TileSwitchRouting.class, (String)"RCTileStructureSwitchRouting");
        GameRegistry.registerTileEntity(TileSignalDistantSignal.class, (String)"RCTileStructureDistantSignal");
        GameRegistry.registerTileEntity(TileSignalDualHeadBlockSignal.class, (String)"RCTileStructureDualHeadBlockSignal");
        GameRegistry.registerTileEntity(TileSignalBlockSignal.class, (String)"RCTileStructureBlockSignal");
        GameRegistry.registerTileEntity(TileSignalDualHeadDistantSignal.class, (String)"RCTileStructureDualHeadDistantSignal");
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumSignal type : EnumSignal.getCreativeList()) {
            if (!type.isEnabled()) continue;
            list.add(type.getItem());
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        texturesBox = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:signal.box", 6);
        texturesLampBox = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:signal.lamp.box", 4);
        texturesLampTop = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:signal.lamp.top", 4);
        texturesLampBottom = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:signal.lamp.bottom", 4);
        texturesSignalSingle = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:signal.single", 5);
        texturesSignalDual = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:signal.dual", 5);
        texturesSwitch = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:signal.switch", 2);
        texturesSwitchTarget = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:signal.switch.target", 2);
        texturesSwitchLever = iconRegister.func_94245_a("railcraft:signal.switch.throw");
        EnumSignal.BOX_BLOCK_RELAY.setIcon(iconRegister.func_94245_a("railcraft:signal.box.block.relay"));
        EnumSignal.BOX_CAPACITOR.setIcon(iconRegister.func_94245_a("railcraft:signal.box.capacitor"));
        EnumSignal.BOX_CONTROLLER.setIcon(iconRegister.func_94245_a("railcraft:signal.box.controller"));
        EnumSignal.BOX_RECEIVER.setIcon(iconRegister.func_94245_a("railcraft:signal.box.receiver"));
        EnumSignal.BOX_SEQUENCER.setIcon(iconRegister.func_94245_a("railcraft:signal.box.sequencer"));
        EnumSignal.BOX_INTERLOCK.setIcon(iconRegister.func_94245_a("railcraft:signal.box.interlock"));
        EnumSignal.SWITCH_MOTOR.setIcon(iconRegister.func_94245_a("railcraft:signal.switch.motor"));
        EnumSignal.SWITCH_LEVER.setIcon(iconRegister.func_94245_a("railcraft:signal.switch.lever"));
        EnumSignal.SWITCH_ROUTING.setIcon(iconRegister.func_94245_a("railcraft:signal.switch.routing"));
    }

    public IIcon func_149691_a(int side, int meta) {
        EnumSignal type = EnumSignal.fromId(meta);
        switch (type) {
            case DUAL_HEAD_BLOCK_SIGNAL: 
            case DUAL_HEAD_DISTANT_SIGNAL: {
                return texturesSignalDual[0];
            }
            case DISTANT_SIGNAL: 
            case BLOCK_SIGNAL: {
                return texturesSignalSingle[0];
            }
        }
        return type.getIcon();
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int side, float u1, float u2, float u3) {
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof IActivationBlockingItem) {
            return false;
        }
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).blockActivated(side, player);
        }
        return false;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).rotateBlock(axis);
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getValidRotations();
        }
        return super.getValidRotations(world, x, y, z);
    }

    public void func_149714_e(World world, int i, int j, int k, int meta) {
        super.func_149714_e(world, i, j, k, meta);
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).onBlockPlaced();
        }
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).onBlockPlacedBy(entityliving);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        try {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileSignalFoundation) {
                TileSignalFoundation structure = (TileSignalFoundation)tile;
                if (structure.getSignalType().needsSupport() && !world.isSideSolid(x, y - 1, z, ForgeDirection.UP)) {
                    world.func_147480_a(x, y, z, true);
                } else {
                    structure.onNeighborBlockChange(block);
                }
            }
        }
        catch (StackOverflowError error) {
            Game.logThrowable(Level.ERROR, "Error in BlockSignal.onNeighborBlockChange()", 10, error, new Object[0]);
            throw error;
        }
    }

    public void func_149749_a(World world, int i, int j, int k, Block block, int meta) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).onBlockRemoval();
        }
        super.func_149749_a(world, i, j, k, block, meta);
    }

    public void func_149719_a(IBlockAccess world, int i, int j, int k) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).setBlockBoundsBasedOnState(world, i, j, k);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getCollisionBoundingBoxFromPool(world, i, j, k);
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return super.func_149668_a(world, i, j, k);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getSelectedBoundingBoxFromPool(world, x, y, z);
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)x + this.field_149759_B, (double)y + this.field_149760_C, (double)z + this.field_149754_D, (double)x + this.field_149755_E, (double)y + this.field_149756_F, (double)z + this.field_149757_G);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (y < 0) {
            return 0;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof ISignalTile) {
            return ((ISignalTile)tile).getLightValue();
        }
        return 0;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getHardness();
        }
        int md = world.func_72805_g(x, y, z);
        return EnumSignal.fromId(md).getHardness();
    }

    public boolean isSideSolid(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).isSideSolid(world, i, j, k, side);
        }
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return this.renderType;
    }

    public TileEntity func_149915_a(World var1, int meta) {
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return EnumSignal.fromId(metadata).getBlockEntity();
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int i, int j, int k, int dir) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).canConnectRedstone(dir);
        }
        return false;
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int i, int j, int k, int side) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getPowerOutput(side);
        }
        return 0;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    @Override
    public IPostConnection.ConnectStyle connectsToPost(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity t = world.func_147438_o(x, y, z);
        if (t instanceof ISignalTile) {
            return IPostConnection.ConnectStyle.TWO_THIN;
        }
        return IPostConnection.ConnectStyle.NONE;
    }
}

