/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import buildcraft.api.gates.IAction;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasCart;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasWork;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.PhantomInventory;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileLoaderBase
extends TileMachineItem
implements IHasCart,
IHasWork {
    public static final float STOP_VELOCITY = 0.02f;
    public static final int PAUSE_DELAY = 4;
    protected EntityMinecart currentCart;
    private final PhantomInventory invCarts = new PhantomInventory(2, this);
    private boolean powered;
    private boolean sendCartGateAction = false;
    private int pause = 0;

    @Override
    public boolean hasMinecart() {
        return this.currentCart != null;
    }

    @Override
    public boolean hasWork() {
        return this.hasMinecart();
    }

    public final PhantomInventory getCartFilters() {
        return this.invCarts;
    }

    @Override
    public void actionActivated(IAction action) {
        if (action == Actions.SEND_CART) {
            this.sendCartGateAction = true;
        }
        if (action == Actions.PAUSE) {
            this.pause = 4;
        }
    }

    public boolean isSendCartGateAction() {
        return this.sendCartGateAction;
    }

    public void cartWasSent() {
        this.sendCartGateAction = false;
    }

    public boolean isPaused() {
        return this.pause > 0;
    }

    @Override
    public final boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (this.pause > 0) {
            --this.pause;
        }
    }

    @Override
    public final boolean canConnectRedstone(int dir) {
        return true;
    }

    @Override
    public final boolean isPoweringTo(int side) {
        if (!this.isPowered()) {
            return false;
        }
        ForgeDirection opSide = MiscTools.getOppositeSide(side);
        Block block = WorldPlugin.getBlockOnSide((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, opSide);
        return TrackTools.isRailBlock(block) || block == Blocks.field_150488_af || block == Blocks.field_150416_aS || block == Blocks.field_150413_aR;
    }

    public final boolean isPowered() {
        return this.powered;
    }

    protected void setPowered(boolean p) {
        if (this.powered != p) {
            this.powered = p;
            this.notifyBlocksOfNeighborChange();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74757_a("powered", this.powered);
        this.getCartFilters().writeToNBT("invCarts", data);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.setPowered(data.func_74767_n("powered"));
        this.getCartFilters().readFromNBT("invCarts", data);
    }
}

