/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileTankBase;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileTankIronGauge
extends TileTankBase {
    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.TANK_IRON_GAUGE;
    }

    @Override
    public IIcon getIcon(int side) {
        if (!this.isStructureValid() || this.getPattern() == null) {
            return this.getTextureFromMachine(side);
        }
        int px = this.getPatternPositionX();
        int py = this.getPatternPositionY();
        int pz = this.getPatternPositionZ();
        ForgeDirection s = ForgeDirection.getOrientation((int)side);
        char markerSide = this.getPattern().getPatternMarkerChecked(MiscTools.getXOnSide(px, s), MiscTools.getYOnSide(py, s), MiscTools.getZOnSide(pz, s));
        if (!this.isMapPositionOtherBlock(markerSide)) {
            return this.getTextureFromMachine(9);
        }
        if (s == ForgeDirection.UP || s == ForgeDirection.DOWN) {
            char markerTop = this.getPattern().getPatternMarkerChecked(px, py + 1, pz);
            if (markerTop == 'A' || markerTop == 'O') {
                int metaUp = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
                int metaDown = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                return this.getTextureBasedOnNeighbors(metaUp, metaDown);
            }
            return this.getTextureFromMachine(0);
        }
        int metaUp = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        int metaDown = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        return this.getTextureBasedOnNeighbors(metaUp, metaDown);
    }

    private IIcon getTextureBasedOnNeighbors(int metaUp, int metaDown) {
        if (metaUp == this.func_145832_p() && metaDown == this.func_145832_p()) {
            return this.getTextureFromMachine(7);
        }
        if (metaUp == this.func_145832_p()) {
            return this.getTextureFromMachine(8);
        }
        if (metaDown == this.func_145832_p()) {
            return this.getTextureFromMachine(6);
        }
        return this.getTextureFromMachine(0);
    }

    private IIcon getTextureFromMachine(int index) {
        return this.getMachineType().getTexture(index);
    }
}

