/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.beta.EngineTools;
import mods.railcraft.common.gui.widgets.IIndicatorController;
import mods.railcraft.common.gui.widgets.IndicatorController;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEngine
extends TileMachineBase
implements IPowerReceptor,
IPipeConnection,
IPowerEmitter {
    private ForgeDirection direction = ForgeDirection.UP;
    private float pistonProgress = 0.0f;
    public float currentOutput = 0.0f;
    private int pistonStage;
    private boolean powered;
    private boolean isActive;
    private boolean needsInit = true;
    public double energy;
    public double extraEnergy;
    private EnergyStage energyStage = EnergyStage.BLUE;
    private final PowerHandler provider = new PowerHandler(this, PowerHandler.Type.ENGINE);
    private final IIndicatorController energyIndicator = new EnergyIndicator();

    public IIndicatorController getEnergyIndicator() {
        return this.energyIndicator;
    }

    public float getCurrentOutput() {
        return this.currentOutput;
    }

    public double getEnergy() {
        return this.energy;
    }

    public TileEngine() {
        this.initEnergyProvider();
    }

    private void initEnergyProvider() {
        this.provider.configure(2.0, this.maxEnergyReceived(), 1.0, this.maxEnergy());
        this.provider.configurePowerPerdition(1, 100);
    }

    protected void playSoundIn() {
    }

    protected void playSoundOut() {
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.field_145850_b)) {
            if (this.pistonStage != 0) {
                this.pistonProgress = (float)((double)this.pistonProgress + this.getPistonSpeed());
                if ((double)this.pistonProgress > 0.5 && this.pistonStage == 1) {
                    this.pistonStage = 2;
                    this.playSoundOut();
                } else if (this.pistonProgress >= 1.0f) {
                    this.pistonStage = 0;
                    this.pistonProgress = 0.0f;
                    this.playSoundIn();
                }
            } else if (this.isActive) {
                this.pistonStage = 1;
            }
            return;
        }
        if (this.needsInit) {
            this.needsInit = false;
            this.checkPower();
        }
        if (!this.powered && this.energy > 1.0) {
            this.energy -= 1.0;
        }
        this.provider.update();
        if (this.getEnergyStage() == EnergyStage.OVERHEAT) {
            this.overheat();
        } else if (this.pistonStage != 0) {
            this.pistonProgress = (float)((double)this.pistonProgress + this.getPistonSpeed());
            if ((double)this.pistonProgress > 0.5 && this.pistonStage == 1) {
                IPowerReceptor receptor;
                PowerHandler.PowerReceiver recProv;
                double extracted;
                this.pistonStage = 2;
                TileEntity tile = WorldPlugin.getTileEntityOnSide(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.direction);
                if (EngineTools.isPoweredTile(tile, this.direction.getOpposite()) && (extracted = this.extractEnergy((recProv = (receptor = (IPowerReceptor)tile).getPowerReceiver(this.direction.getOpposite())).getMinEnergyReceived(), recProv.getMaxEnergyReceived(), true)) > 0.0) {
                    recProv.receiveEnergy(PowerHandler.Type.ENGINE, extracted, this.direction.getOpposite());
                }
            } else if (this.pistonProgress >= 1.0f) {
                this.pistonProgress = 0.0f;
                this.pistonStage = 0;
            }
        } else if (this.powered) {
            TileEntity tile = WorldPlugin.getTileEntityOnSide(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.direction);
            if (EngineTools.isPoweredTile(tile, this.direction.getOpposite())) {
                IPowerReceptor receptor = (IPowerReceptor)tile;
                PowerHandler.PowerReceiver recProv = receptor.getPowerReceiver(this.direction.getOpposite());
                if (this.extractEnergy(recProv.getMinEnergyReceived(), recProv.getMaxEnergyReceived(), false) > 0.0) {
                    this.pistonStage = 1;
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        this.burn();
    }

    protected void overheat() {
        this.subtractEnergy(5.0);
    }

    protected abstract void burn();

    private void setActive(boolean isActive) {
        if (this.isActive != isActive) {
            this.isActive = isActive;
            this.sendUpdateToClient();
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public double getPistonSpeed() {
        if (Game.isHost(this.field_145850_b)) {
            return Math.max(0.16 * this.getEnergyLevel(), 0.01);
        }
        switch (this.getEnergyStage()) {
            case BLUE: {
                return 0.01;
            }
            case GREEN: {
                return 0.02;
            }
            case YELLOW: {
                return 0.04;
            }
            case ORANGE: {
                return 0.08;
            }
            case RED: {
                return 0.16;
            }
        }
        return 0.0;
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        IToolWrench wrench;
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null && current.func_77973_b() instanceof IToolWrench && (wrench = (IToolWrench)current.func_77973_b()).canWrench(player, this.field_145851_c, this.field_145848_d, this.field_145849_e) && Game.isHost(this.field_145850_b) && this.getEnergyStage() == EnergyStage.OVERHEAT) {
            this.resetEnergyStage();
            wrench.wrenchUsed(player, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        return this.switchOrientation();
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving) {
        super.onBlockPlacedBy(entityliving);
        this.switchOrientation();
        this.checkPower();
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.checkPower();
    }

    private void checkPower() {
        boolean p = PowerPlugin.isBlockBeingPowered(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.powered != p) {
            this.powered = p;
            this.sendUpdateToClient();
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public boolean canConnectRedstone(int dir) {
        return true;
    }

    public boolean switchOrientation() {
        for (int i = this.direction.ordinal() + 1; i <= this.direction.ordinal() + 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)(i % 6));
            TileEntity tile = WorldPlugin.getTileEntityOnSide(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, dir);
            if (!EngineTools.isPoweredTile(tile, dir.getOpposite())) continue;
            this.direction = dir;
            this.notifyBlocksOfNeighborChange();
            this.sendUpdateToClient();
            if (Game.isNotHost(this.field_145850_b)) {
                this.markBlockForUpdate();
            }
            return true;
        }
        return false;
    }

    public ForgeDirection getOrientation() {
        return this.direction;
    }

    @Override
    public boolean isSideSolid(ForgeDirection side) {
        return this.direction.getOpposite() == side;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.provider.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (Game.isNotHost(this.field_145850_b)) {
            return;
        }
        double e = this.provider.useEnergy(1.0, this.maxEnergyReceived(), true) * 0.95;
        this.extraEnergy += e;
        this.addEnergy(e);
    }

    public double getEnergyLevel() {
        return this.energy / (double)this.maxEnergy();
    }

    protected EnergyStage computeEnergyStage() {
        double energyLevel = this.getEnergyLevel();
        if (energyLevel < 0.2) {
            return EnergyStage.BLUE;
        }
        if (energyLevel < 0.4) {
            return EnergyStage.GREEN;
        }
        if (energyLevel < 0.6) {
            return EnergyStage.YELLOW;
        }
        if (energyLevel < 0.8) {
            return EnergyStage.ORANGE;
        }
        if (energyLevel < 1.0) {
            return EnergyStage.RED;
        }
        return EnergyStage.OVERHEAT;
    }

    public final EnergyStage getEnergyStage() {
        if (Game.isHost(this.field_145850_b)) {
            if (this.energyStage == EnergyStage.OVERHEAT) {
                return this.energyStage;
            }
            EnergyStage newStage = this.computeEnergyStage();
            if (this.energyStage != newStage) {
                this.energyStage = newStage;
                this.sendUpdateToClient();
            }
        }
        return this.energyStage;
    }

    public final void resetEnergyStage() {
        EnergyStage newStage = this.computeEnergyStage();
        if (this.energyStage != newStage) {
            this.energyStage = newStage;
            this.sendUpdateToClient();
        }
    }

    public void addEnergy(double addition) {
        this.energy += addition;
        if (this.energy > (double)this.maxEnergy()) {
            this.energy = this.maxEnergy();
        }
    }

    public void subtractEnergy(double subtraction) {
        this.energy -= subtraction;
        if (this.energy < 0.0) {
            this.energy = 0.0;
        }
    }

    public double extractEnergy(double min, double max, boolean doExtract) {
        double extracted;
        if (this.energy < min) {
            return 0.0;
        }
        double combinedMax = (double)this.maxEnergyExtracted() + this.extraEnergy * 0.5;
        double actualMax = max > combinedMax ? combinedMax : max;
        if (this.energy >= actualMax) {
            extracted = actualMax;
            if (doExtract) {
                this.energy -= actualMax;
                this.extraEnergy -= Math.min(actualMax, this.extraEnergy);
            }
        } else {
            extracted = this.energy;
            if (doExtract) {
                this.energy = 0.0;
                this.extraEnergy = 0.0;
            }
        }
        return extracted;
    }

    public float getProgress() {
        return this.pistonProgress;
    }

    public abstract int maxEnergy();

    public abstract int maxEnergyExtracted();

    public abstract int maxEnergyReceived();

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("direction", (byte)this.direction.ordinal());
        data.func_74757_a("powered", this.powered);
        data.func_74776_a("energy", (float)this.energy);
        data.func_74776_a("currentOutput", this.currentOutput);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.direction = ForgeDirection.getOrientation((int)data.func_74771_c("direction"));
        this.powered = data.func_74767_n("powered");
        this.energy = data.func_74760_g("energy");
        this.currentOutput = data.func_74760_g("currentOutput");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.direction.ordinal());
        data.writeByte(this.getEnergyStage().ordinal());
        data.writeBoolean(this.isActive);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.energyStage = EnergyStage.fromOrdinal(data.readByte());
        this.isActive = data.readBoolean();
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        if (type == IPipeTile.PipeType.POWER) {
            return IPipeConnection.ConnectOverride.DEFAULT;
        }
        if (with == this.direction) {
            return IPipeConnection.ConnectOverride.DISCONNECT;
        }
        return IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public boolean canEmitPowerFrom(ForgeDirection side) {
        return side == this.direction;
    }

    public static enum EnergyStage {
        BLUE,
        GREEN,
        YELLOW,
        ORANGE,
        RED,
        OVERHEAT;

        public static final EnergyStage[] VALUES;

        public static EnergyStage fromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= VALUES.length) {
                return BLUE;
            }
            return VALUES[ordinal];
        }

        static {
            VALUES = EnergyStage.values();
        }
    }

    private class EnergyIndicator
    extends IndicatorController {
        private EnergyIndicator() {
        }

        @Override
        public void refreshToolTip() {
            this.tip.text = String.format("%.0f MJ", TileEngine.this.energy);
        }

        @Override
        public int getScaledLevel(int size) {
            double e = Math.min(TileEngine.this.energy, (double)TileEngine.this.maxEnergy());
            return (int)(e * (double)size / (double)TileEngine.this.maxEnergy());
        }
    }
}

