/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha.ai;

import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.world.IBlockAccess;

public class EntityAIWatchBlock
extends EntityAIBase {
    private final EntityLiving theWatcher;
    protected WorldCoordinate watchedBlock;
    private final int maxDist;
    private int lookTime;
    private final float weight;
    private final Block searchedBlock;
    private final int searchedMeta;

    public EntityAIWatchBlock(EntityLiving entity, Block searchedBlock, int searchedMeta, int maxDist) {
        this(entity, searchedBlock, searchedMeta, maxDist, 0.02f);
    }

    public EntityAIWatchBlock(EntityLiving entity, Block searchedBlock, int searchedMeta, int maxDist, float weight) {
        this.theWatcher = entity;
        this.searchedBlock = searchedBlock;
        this.searchedMeta = searchedMeta;
        this.maxDist = maxDist;
        this.weight = weight;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.theWatcher.func_70681_au().nextFloat() >= this.weight) {
            return false;
        }
        if (this.watchedBlock == null || !this.isBlockValid()) {
            this.watchedBlock = WorldPlugin.findBlock(this.theWatcher.field_70170_p, (int)this.theWatcher.field_70165_t, (int)this.theWatcher.field_70163_u, (int)this.theWatcher.field_70161_v, this.maxDist, this.searchedBlock, this.searchedMeta);
        }
        return this.watchedBlock != null;
    }

    private boolean isBlockValid() {
        if (this.searchedBlock != WorldPlugin.getBlock((IBlockAccess)this.theWatcher.field_70170_p, this.watchedBlock)) {
            return false;
        }
        return WorldPlugin.getDistanceSq(this.watchedBlock, this.theWatcher.field_70165_t, this.theWatcher.field_70163_u, this.theWatcher.field_70161_v) <= (double)(this.maxDist * this.maxDist);
    }

    public boolean func_75253_b() {
        if (!this.isBlockValid()) {
            return false;
        }
        return this.lookTime > 0;
    }

    public void func_75249_e() {
        this.lookTime = 40 + this.theWatcher.func_70681_au().nextInt(40);
    }

    public void func_75251_c() {
        this.watchedBlock = null;
    }

    public void func_75246_d() {
        this.theWatcher.func_70671_ap().func_75650_a((double)this.watchedBlock.x + 0.5, (double)this.watchedBlock.y + 0.5, (double)this.watchedBlock.z + 0.5, 10.0f, (float)this.theWatcher.func_70646_bf());
        --this.lookTime;
    }
}

