/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.alpha.ai.EntityAIMoveToBlock;
import mods.railcraft.common.blocks.machine.alpha.ai.EntityAIWatchBlock;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.AIPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.PhantomInventory;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileTradeStation
extends TileMachineItem
implements IGuiReturnHandler,
ISidedInventory {
    private static final int AREA = 6;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 16);
    private int profession;
    private final PhantomInventory recipeSlots = new PhantomInventory(9);
    private final InventoryMapper invInput;
    private final InventoryMapper invOutput;
    protected ForgeDirection direction = ForgeDirection.NORTH;

    public TileTradeStation() {
        this.setInventorySize(16);
        this.invInput = new InventoryMapper(this, 0, 10);
        this.invOutput = new InventoryMapper(this, 10, 6, false);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.TRADE_STATION;
    }

    @Override
    public IIcon getIcon(int side) {
        if (side == this.direction.ordinal()) {
            return this.getMachineType().getTexture(4);
        }
        if (side < 2) {
            return this.getMachineType().getTexture(0);
        }
        return this.getMachineType().getTexture(2);
    }

    public IInventory getRecipeSlots() {
        return this.recipeSlots;
    }

    public int getProfession() {
        return this.profession;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.TRADE_STATION, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.clock % 256 == 0) {
            this.modifyNearbyAI();
        }
        List<EntityVillager> villagers = MiscTools.getNearbyEntities(this.field_145850_b, EntityVillager.class, this.field_145851_c, this.field_145848_d - 1, this.field_145848_d + 3, this.field_145849_e, 6.0f);
        this.attemptTrade(villagers, 0);
        this.attemptTrade(villagers, 1);
        this.attemptTrade(villagers, 2);
    }

    private void modifyNearbyAI() {
        List<EntityVillager> villagers = MiscTools.getNearbyEntities(this.field_145850_b, EntityVillager.class, this.field_145851_c, this.field_145848_d - 1, this.field_145848_d + 3, this.field_145849_e, 20.0f);
        for (EntityVillager villager : villagers) {
            AIPlugin.addAITask((EntityLiving)villager, 9, new EntityAIWatchBlock((EntityLiving)villager, this.getMachineType().getBlock(), this.getMachineType().ordinal(), 4, 0.08f));
            AIPlugin.addAITask((EntityLiving)villager, 9, new EntityAIMoveToBlock((EntityCreature)villager, this.getMachineType().getBlock(), this.getMachineType().ordinal(), 16, 0.002f));
        }
    }

    private boolean attemptTrade(List<EntityVillager> villagers, int tradeSet) {
        ItemStack buy1 = this.recipeSlots.func_70301_a(tradeSet * 3 + 0);
        ItemStack buy2 = this.recipeSlots.func_70301_a(tradeSet * 3 + 1);
        ItemStack sell = this.recipeSlots.func_70301_a(tradeSet * 3 + 2);
        for (EntityVillager villager : villagers) {
            MerchantRecipeList recipes = villager.func_70934_b(null);
            for (MerchantRecipe recipe : recipes) {
                if (recipe.func_82784_g() || recipe.func_77394_a() != null && !InvTools.isItemLessThanOrEqualTo(recipe.func_77394_a(), buy1) || recipe.func_77396_b() != null && !InvTools.isItemLessThanOrEqualTo(recipe.func_77396_b(), buy2) || !InvTools.isItemLessThanOrEqualTo(recipe.func_77397_d(), sell) || !this.canDoTrade(recipe)) continue;
                this.doTrade((IMerchant)villager, recipe);
                return true;
            }
        }
        return false;
    }

    private boolean canDoTrade(MerchantRecipe recipe) {
        if (recipe.func_77394_a() != null && InvTools.countItems((IInventory)this.invInput, recipe.func_77394_a()) < recipe.func_77394_a().field_77994_a) {
            return false;
        }
        if (recipe.func_77396_b() != null && InvTools.countItems((IInventory)this.invInput, recipe.func_77396_b()) < recipe.func_77396_b().field_77994_a) {
            return false;
        }
        return InvTools.isRoomForStack(recipe.func_77397_d(), this.invOutput);
    }

    private void doTrade(IMerchant merchant, MerchantRecipe recipe) {
        merchant.func_70933_a(recipe);
        if (recipe.func_77394_a() != null) {
            InvTools.removeItemsAbsolute((IInventory)this.invInput, recipe.func_77394_a().field_77994_a, recipe.func_77394_a());
        }
        if (recipe.func_77396_b() != null) {
            InvTools.removeItemsAbsolute((IInventory)this.invInput, recipe.func_77396_b().field_77994_a, recipe.func_77396_b());
        }
        InvTools.moveItemStack(recipe.func_77397_d().func_77946_l(), this.invOutput);
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving) {
        super.onBlockPlacedBy(entityliving);
        this.direction = MiscTools.getSideClosestToPlayer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, entityliving);
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        this.direction = this.direction == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.recipeSlots.writeToNBT("recipe", data);
        data.func_74768_a("profession", this.profession);
        data.func_74774_a("direction", (byte)this.direction.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.recipeSlots.readFromNBT("recipe", data);
        this.profession = data.func_74762_e("profession");
        this.direction = ForgeDirection.getOrientation((int)data.func_74771_c("direction"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeInt(this.profession);
        data.writeByte(this.direction.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.profession = data.readInt();
        ForgeDirection f = ForgeDirection.getOrientation((int)data.readByte());
        if (this.direction != f) {
            this.direction = f;
            this.markBlockForUpdate();
        }
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        GuiPacketType type = GuiPacketType.values()[data.readByte()];
        switch (type) {
            case NEXT_TRADE: {
                this.nextTrade(data.readByte());
                break;
            }
            case SET_PROFESSION: {
                this.profession = data.readInt();
                this.sendUpdateToClient();
            }
        }
    }

    public void nextTrade(int tradeSet) {
        EntityVillager villager = new EntityVillager(this.field_145850_b);
        villager.func_70938_b(this.profession);
        MerchantRecipeList recipes = villager.func_70934_b(null);
        MerchantRecipe recipe = (MerchantRecipe)recipes.get(MiscTools.RANDOM.nextInt(recipes.size()));
        this.recipeSlots.func_70299_a(tradeSet * 3 + 0, recipe.func_77394_a());
        this.recipeSlots.func_70299_a(tradeSet * 3 + 1, recipe.func_77396_b());
        this.recipeSlots.func_70299_a(tradeSet * 3 + 2, recipe.func_77397_d());
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot < 10;
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot >= 10;
    }

    public static enum GuiPacketType {
        NEXT_TRADE,
        SET_PROFESSION;

    }
}

