/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.ISteamUser;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFirebox;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.FakeTank;
import mods.railcraft.common.fluids.tanks.FilteredTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.items.RailcraftPartItems;
import mods.railcraft.common.plugins.buildcraft.triggers.INeedsMaintenance;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.plugins.ic2.IC2Plugin;
import mods.railcraft.common.plugins.ic2.IMultiEmitterDelegate;
import mods.railcraft.common.plugins.ic2.TileIC2MultiEmitterDelegate;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileSteamTurbine
extends TileMultiBlock
implements IMultiEmitterDelegate,
IFluidHandler,
INeedsMaintenance,
ISteamUser {
    private static final int DAMAGE_CHANCE = 200;
    private static final int IC2_OUTPUT = 200;
    private static final int BC_OUTPUT = 64;
    private static final int STEAM_USAGE = 320;
    private static final int WATER_OUTPUT = 4;
    private static final List<MultiBlockPattern> patterns = new ArrayList<MultiBlockPattern>();
    private static ItemStack sampleRotor = null;
    private final StandaloneInventory inv = new StandaloneInventory(1, this);
    public float output;
    private final FluidStack waterFilter = Fluids.WATER.get(2);
    protected final FilteredTank tankSteam = new FilteredTank(4000, Fluids.STEAM.get(), this);
    protected final FilteredTank tankWater = new FilteredTank(4000, Fluids.WATER.get(), this);
    protected final TankManager tankManager = new TankManager();
    public static final int TANK_STEAM = 0;
    public static final int TANK_WATER = 1;
    private byte gaugeState = 0;
    public double mainGauge;
    private float energy;
    private TileEntity emitterDelegate;

    public static ItemStack getSampleRotor() {
        if (sampleRotor == null) {
            sampleRotor = RailcraftPartItems.getTurbineRotor();
        }
        return sampleRotor;
    }

    public TileSteamTurbine() {
        super(patterns);
        this.tankManager.add(this.tankSteam);
        this.tankManager.add(this.tankWater);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.TURBINE;
    }

    @Override
    public void func_145845_h() {
        TankManager tMan;
        super.func_145845_h();
        if (this.isMaster() && Game.isHost(this.field_145850_b)) {
            ItemStack rotor;
            FluidStack steam;
            this.addToNet();
            boolean addedEnergy = false;
            if (this.energy < 128.0f && (steam = this.tankManager.drain(0, 320, false)) != null && steam.amount >= 320 && InvTools.isItemEqual(rotor = this.inv.func_70301_a(0), TileSteamTurbine.getSampleRotor())) {
                addedEnergy = true;
                this.energy += 64.0f;
                this.tankManager.drain(0, 320, true);
                if (this.field_145850_b.field_73012_v.nextInt(4) != 0) {
                    this.tankWater.fill(this.waterFilter, true);
                }
                if (this.field_145850_b.field_73012_v.nextInt(200) == 0) {
                    this.inv.func_70299_a(0, InvTools.damageItem(rotor, 1));
                }
            }
            this.output = (float)(((double)this.output * 49.0 + (addedEnergy ? 100.0 : 0.0)) / 50.0);
            if (this.clock % 4 == 0) {
                this.gaugeState = (byte)this.getOutput();
                WorldPlugin.addBlockEvent(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.gaugeState);
            }
        }
        if ((tMan = this.getTankManager()) != null) {
            tMan.outputLiquid(this.getOutputs(), 0, 4);
        }
    }

    private IFluidHandler getOutputOnSide(ForgeDirection side) {
        TileEntity tile = this.tileCache.getTileOnSide(side);
        if (tile instanceof TileBoilerFirebox) {
            return (IFluidHandler)tile;
        }
        return null;
    }

    private IFluidHandler[] getOutputs() {
        IFluidHandler[] outputs = new IFluidHandler[6];
        for (int side = 2; side < 6; ++side) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            outputs[side] = this.getOutputOnSide(dir);
        }
        return outputs;
    }

    private void addToNet() {
        if (this.emitterDelegate == null) {
            try {
                this.emitterDelegate = new TileIC2MultiEmitterDelegate(this);
                IC2Plugin.addTileToNet(this.emitterDelegate);
            }
            catch (Throwable error) {
                Game.logErrorAPI("IndustrialCraft", error, null);
            }
        }
    }

    private void dropFromNet() {
        if (this.emitterDelegate != null) {
            IC2Plugin.removeTileFromNet(this.emitterDelegate);
            this.emitterDelegate = null;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.dropFromNet();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.dropFromNet();
    }

    @Override
    protected void onMasterReset() {
        super.onMasterReset();
        this.dropFromNet();
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        InvTools.dropInventory(this.inv, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.TURBINE, player, this.field_145850_b, mBlock.field_145851_c, mBlock.field_145848_d, mBlock.field_145849_e);
            return true;
        }
        return false;
    }

    public boolean hasEnergy() {
        return this.getEnergy() >= 64.0f;
    }

    public void removeEnergy(float amount) {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.energy -= amount;
            if (mBlock.energy < 0.0f) {
                mBlock.energy = 0.0f;
            }
        }
    }

    public float getEnergy() {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        if (mBlock == null) {
            return 0.0f;
        }
        return mBlock.energy;
    }

    public float getOutput() {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        if (mBlock == null) {
            return 0.0f;
        }
        return mBlock.output;
    }

    public float getMainGauge() {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        if (mBlock == null) {
            return 0.0f;
        }
        return (float)mBlock.gaugeState * 0.01f;
    }

    @Override
    public IIcon getIcon(int side) {
        if (this.isStructureValid()) {
            int patIndex = patterns.indexOf(this.getPattern());
            if (side == 0 || side == 1) {
                if (patIndex == 0) {
                    return Texture.SIDE_B.getIcon();
                }
                return Texture.SIDE_A.getIcon();
            }
            if (this.getPatternMarker() == 'W') {
                return Texture.GUAGE.getIcon();
            }
            if (patIndex == 0) {
                switch (side) {
                    case 2: {
                        if (this.getPatternPositionY() == 2) {
                            if (this.getPatternPositionX() == 2) {
                                return Texture.END_TR.getIcon();
                            }
                            return Texture.END_TL.getIcon();
                        }
                        if (this.getPatternPositionX() == 2) {
                            return Texture.END_BR.getIcon();
                        }
                        return Texture.END_BL.getIcon();
                    }
                    case 3: {
                        if (this.getPatternPositionY() == 2) {
                            if (this.getPatternPositionX() == 1) {
                                return Texture.END_TL.getIcon();
                            }
                            return Texture.END_TR.getIcon();
                        }
                        if (this.getPatternPositionX() == 1) {
                            return Texture.END_BL.getIcon();
                        }
                        return Texture.END_BR.getIcon();
                    }
                }
            } else {
                switch (side) {
                    case 4: {
                        if (this.getPatternPositionY() == 2) {
                            if (this.getPatternPositionZ() == 1) {
                                return Texture.END_TL.getIcon();
                            }
                            return Texture.END_TR.getIcon();
                        }
                        if (this.getPatternPositionZ() == 1) {
                            return Texture.END_BL.getIcon();
                        }
                        return Texture.END_BR.getIcon();
                    }
                    case 5: {
                        if (this.getPatternPositionY() == 2) {
                            if (this.getPatternPositionZ() == 2) {
                                return Texture.END_TR.getIcon();
                            }
                            return Texture.END_TL.getIcon();
                        }
                        if (this.getPatternPositionZ() == 2) {
                            return Texture.END_BR.getIcon();
                        }
                        return Texture.END_BL.getIcon();
                    }
                }
            }
        }
        return Texture.SIDE_A.getIcon();
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.inv.writeToNBT("rotor", data);
        this.tankManager.writeTanksToNBT(data);
        data.func_74776_a("energy", this.energy);
        data.func_74776_a("output", this.output);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.inv.readFromNBT("rotor", data);
        this.tankManager.readTanksFromNBT(data);
        this.energy = data.func_74760_g("energy");
        this.output = data.func_74760_g("output");
    }

    public boolean func_145842_c(int id, int value) {
        if (id == 1) {
            this.gaugeState = (byte)value;
            return true;
        }
        return super.func_145842_c(id, value);
    }

    @Override
    public double getOfferedEnergy() {
        if (this.hasEnergy()) {
            return 200.0;
        }
        return 0.0;
    }

    @Override
    public void drawEnergy(double amount) {
        this.removeEnergy((float)amount / 200.0f * 64.0f);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public List<TileEntity> getSubTiles() {
        return this.getComponents();
    }

    public StandaloneInventory getInventory() {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.inv;
        }
        return this.inv;
    }

    public TankManager getTankManager() {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager;
        }
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.fill(0, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.drain(1, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (Fluids.WATER.is(resource)) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTankInfo();
        }
        return FakeTank.INFO;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == null || Fluids.STEAM.is(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == null || Fluids.WATER.is(fluid);
    }

    @Override
    public boolean needsMaintenance() {
        TileSteamTurbine mBlock = (TileSteamTurbine)this.getMasterBlock();
        if (mBlock != null) {
            ItemStack rotor = mBlock.inv.func_70301_a(0);
            if (rotor == null) {
                return true;
            }
            if (!InvTools.isItemEqual(rotor, TileSteamTurbine.getSampleRotor())) {
                return true;
            }
            if ((double)rotor.func_77960_j() / (double)rotor.func_77958_k() > 0.75) {
                return true;
            }
        }
        return false;
    }

    static {
        char[][][] map1 = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map1));
        char[][][] map2 = new char[][][]{new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'W', 'W', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map2));
    }

    static enum Texture {
        END_TL(6),
        END_TR(7),
        END_BL(8),
        END_BR(9),
        SIDE_A(0),
        SIDE_B(10),
        GUAGE(11);

        private final int index;

        private Texture(int index) {
            this.index = index;
        }

        public IIcon getIcon() {
            return EnumMachineAlpha.TURBINE.getTexture(this.index);
        }
    }
}

