/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import mods.railcraft.common.blocks.detector.DetectorFilter;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.TankToolkit;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.buttons.IButtonTextureSet;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.gui.buttons.StandardButtonTextureSets;
import mods.railcraft.common.gui.tooltips.ToolTip;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class DetectorTank
extends DetectorFilter {
    private final MultiButtonController<ButtonState> buttonController = new MultiButtonController(ButtonState.ANALOG.ordinal(), (IMultiButtonState[])ButtonState.values());

    public DetectorTank() {
        super(1);
    }

    public MultiButtonController getButtonController() {
        return this.buttonController;
    }

    public Fluid getFilterLiquid() {
        ItemStack filter = this.getFilters().func_70301_a(0);
        if (filter != null) {
            return FluidHelper.getFluidInContianer(filter);
        }
        return null;
    }

    @Override
    public int testCarts(List<EntityMinecart> carts) {
        for (EntityMinecart cart : carts) {
            if (!(cart instanceof IFluidHandler)) continue;
            TankToolkit tank = new TankToolkit((IFluidHandler)cart);
            boolean liquidMatches = false;
            Fluid filterFluid = this.getFilterLiquid();
            FluidStack tankLiquid = tank.drain(ForgeDirection.UNKNOWN, 1, false);
            if (filterFluid == null) {
                liquidMatches = true;
            } else if (Fluids.areEqual(filterFluid, tankLiquid)) {
                liquidMatches = true;
            } else if (tank.canPutFluid(ForgeDirection.UNKNOWN, new FluidStack(filterFluid, 1))) {
                liquidMatches = true;
            }
            boolean quantityMatches = false;
            ButtonState state = this.buttonController.getButtonState();
            block0 : switch (state) {
                case VOID: {
                    quantityMatches = true;
                    break;
                }
                case EMPTY: {
                    if (filterFluid != null && tank.isTankEmpty(filterFluid)) {
                        quantityMatches = true;
                        break;
                    }
                    if (filterFluid != null || !tank.areTanksEmpty()) break;
                    quantityMatches = true;
                    break;
                }
                case NOT_EMPTY: {
                    if (filterFluid != null && tank.getFluidQty(filterFluid) > 0) {
                        quantityMatches = true;
                        break;
                    }
                    if (filterFluid != null || !tank.isFluidInTank()) break;
                    quantityMatches = true;
                    break;
                }
                case FULL: {
                    if (filterFluid != null && tank.isTankFull(filterFluid)) {
                        quantityMatches = true;
                        break;
                    }
                    if (filterFluid != null || !tank.areTanksFull()) break;
                    quantityMatches = true;
                    break;
                }
                default: {
                    float level = filterFluid != null ? tank.getFluidLevel(filterFluid) : tank.getFluidLevel();
                    switch (state) {
                        case ANALOG: {
                            return (int)(15.0f * level);
                        }
                        case QUARTER: {
                            quantityMatches = level >= 0.25f;
                            break block0;
                        }
                        case HALF: {
                            quantityMatches = level >= 0.5f;
                            break block0;
                        }
                        case MOST: {
                            quantityMatches = level >= 0.75f;
                            break block0;
                        }
                        case LESS_THAN_QUARTER: {
                            quantityMatches = level < 0.25f;
                            break block0;
                        }
                        case LESS_THAN_HALF: {
                            quantityMatches = level < 0.5f;
                            break block0;
                        }
                        case LESS_THAN_MOST: {
                            quantityMatches = level < 0.75f;
                            break block0;
                        }
                        case LESS_THAN_FULL: {
                            quantityMatches = level < 1.0f;
                        }
                    }
                }
            }
            return liquidMatches && quantityMatches ? 15 : 0;
        }
        return 0;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        this.openGui(EnumGui.DETECTOR_TANK, player);
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74774_a("state", (byte)this.buttonController.getCurrentState());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.buttonController.setCurrentState(data.func_74771_c("state"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.buttonController.getCurrentState());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.buttonController.setCurrentState(data.readByte());
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.buttonController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.buttonController.setCurrentState(data.readByte());
    }

    @Override
    public EnumDetector getType() {
        return EnumDetector.TANK;
    }

    public static enum ButtonState implements IMultiButtonState
    {
        VOID("L = *"),
        EMPTY("L = 0%"),
        NOT_EMPTY("L > 0%"),
        FULL("L = 100%"),
        QUARTER("L >= 25%"),
        HALF("L >= 50%"),
        MOST("L >= 75%"),
        LESS_THAN_QUARTER("L < 25%"),
        LESS_THAN_HALF("L < 50%"),
        LESS_THAN_MOST("L < 75%"),
        LESS_THAN_FULL("L < 100%"),
        ANALOG("L = ~");

        private final String label;
        private ToolTip tip;

        private ButtonState(String label) {
            this.label = label;
            this.tip = ToolTip.buildToolTip("gui.detector.tank.tip." + this.name().toLowerCase(Locale.ENGLISH).replace("_", "."), new String[0]);
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public IButtonTextureSet getTextureSet() {
            return StandardButtonTextureSets.LARGE_BUTTON;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }
}

