/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.detector.BlockDetector;
import mods.railcraft.common.blocks.detector.Detector;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.SafeNBTWrapper;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileDetector
extends RailcraftTileEntity
implements IGuiReturnHandler {
    public static final float SENSITIVITY = 0.2f;
    public ForgeDirection direction = ForgeDirection.UP;
    public int powerState = 0;
    public Detector detector = Detector.DUMMY;
    private boolean tested;

    public void setDetector(EnumDetector type) {
        this.detector = type.buildHandler();
        this.detector.setTile(this);
    }

    public Detector getDetector() {
        return this.detector;
    }

    @Override
    public String getName() {
        return RailcraftLanguage.translate(this.getDetector().getType().getTag());
    }

    public List<EntityMinecart> getCarts() {
        return CartTools.getMinecartsOnAllSides(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.2f);
    }

    public boolean blockActivated(EntityPlayer player) {
        return this.detector.blockActivated(player);
    }

    public void onNeighborBlockChange(Block block) {
        this.detector.onNeighborBlockChange(block);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("type", (byte)this.detector.getType().ordinal());
        this.detector.writeToNBT(data);
        data.func_74774_a("direction", (byte)this.direction.ordinal());
        data.func_74774_a("powerState", (byte)this.powerState);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        SafeNBTWrapper safe = new SafeNBTWrapper(data);
        this.direction = ForgeDirection.getOrientation((int)safe.getByte("direction"));
        this.powerState = data.func_74771_c("powerState");
        if (data.func_74764_b("type")) {
            this.setDetector(EnumDetector.fromOrdinal(data.func_74771_c("type")));
        }
        this.detector.readFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.detector.getType().ordinal());
        data.writeByte(this.powerState);
        data.writeByte(this.direction.ordinal());
        this.detector.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        byte type = data.readByte();
        if (this.detector == Detector.DUMMY || this.detector.getType().ordinal() != type) {
            this.setDetector(EnumDetector.fromOrdinal(type));
        }
        this.powerState = data.readByte();
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.detector.readPacketData(data);
        this.markBlockForUpdate();
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (!this.tested) {
            this.tested = true;
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (meta != 0) {
                this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145848_d);
                BlockDetector block = BlockDetector.getBlock();
                if (block != null) {
                    this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145848_d, (Block)block, 0, 3);
                }
            }
        }
        if (this.detector.updateInterval() == 0 || this.clock % this.detector.updateInterval() == 0) {
            int newPowerState;
            int n = newPowerState = this.detector.shouldTest() ? this.detector.testCarts(this.getCarts()) : 0;
            if (newPowerState != this.powerState) {
                this.powerState = newPowerState;
                this.sendUpdateToClient();
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)BlockDetector.getBlock());
                WorldPlugin.notifyBlocksOfNeighborChangeOnSide(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)BlockDetector.getBlock(), this.direction);
            }
        }
    }

    @Override
    public short getId() {
        return 76;
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        this.detector.writeGuiData(data);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.detector.readGuiData(data, sender);
    }
}

