/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector;

import java.util.Locale;
import mods.railcraft.common.blocks.detector.BlockDetector;
import mods.railcraft.common.blocks.detector.Detector;
import mods.railcraft.common.blocks.detector.types.DetectorAdvanced;
import mods.railcraft.common.blocks.detector.types.DetectorAge;
import mods.railcraft.common.blocks.detector.types.DetectorAnimal;
import mods.railcraft.common.blocks.detector.types.DetectorEmpty;
import mods.railcraft.common.blocks.detector.types.DetectorEnergy;
import mods.railcraft.common.blocks.detector.types.DetectorExplosive;
import mods.railcraft.common.blocks.detector.types.DetectorItem;
import mods.railcraft.common.blocks.detector.types.DetectorLocomotive;
import mods.railcraft.common.blocks.detector.types.DetectorMob;
import mods.railcraft.common.blocks.detector.types.DetectorPlayer;
import mods.railcraft.common.blocks.detector.types.DetectorPowered;
import mods.railcraft.common.blocks.detector.types.DetectorRouting;
import mods.railcraft.common.blocks.detector.types.DetectorSheep;
import mods.railcraft.common.blocks.detector.types.DetectorTank;
import mods.railcraft.common.blocks.detector.types.DetectorTrain;
import mods.railcraft.common.blocks.detector.types.DetectorVillager;
import mods.railcraft.common.modules.ModuleManager;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public enum EnumDetector {
    ITEM(ModuleManager.Module.AUTOMATION, DetectorItem.class),
    ANY(ModuleManager.Module.AUTOMATION, Detector.class),
    EMPTY(ModuleManager.Module.AUTOMATION, DetectorEmpty.class),
    MOB(ModuleManager.Module.AUTOMATION, DetectorMob.class),
    POWERED(ModuleManager.Module.AUTOMATION, DetectorPowered.class),
    PLAYER(ModuleManager.Module.AUTOMATION, DetectorPlayer.class),
    EXPLOSIVE(ModuleManager.Module.AUTOMATION, DetectorExplosive.class),
    ANIMAL(ModuleManager.Module.AUTOMATION, DetectorAnimal.class),
    TANK(ModuleManager.Module.AUTOMATION, DetectorTank.class),
    ADVANCED(ModuleManager.Module.AUTOMATION, DetectorAdvanced.class),
    ENERGY(ModuleManager.Module.IC2, DetectorEnergy.class),
    AGE(ModuleManager.Module.AUTOMATION, DetectorAge.class),
    TRAIN(ModuleManager.Module.TRAIN, DetectorTrain.class),
    SHEEP(ModuleManager.Module.AUTOMATION, DetectorSheep.class),
    VILLAGER(ModuleManager.Module.AUTOMATION, DetectorVillager.class),
    LOCOMOTIVE(ModuleManager.Module.AUTOMATION, DetectorLocomotive.class),
    ROUTING(ModuleManager.Module.ROUTING, DetectorRouting.class);

    public static final EnumDetector[] VALUES;
    public IIcon[] textures;
    private final Class<? extends Detector> handler;
    private final ModuleManager.Module module;

    private EnumDetector(ModuleManager.Module module, Class<? extends Detector> handler) {
        this.handler = handler;
        this.module = module;
    }

    public static EnumDetector fromOrdinal(int meta) {
        if (meta >= VALUES.length) {
            meta = 0;
        }
        return VALUES[meta];
    }

    public Detector buildHandler() {
        try {
            return this.handler.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create Detector!");
        }
    }

    public String getTag() {
        return "detector." + this.name().toLowerCase(Locale.ENGLISH);
    }

    public ItemStack getItem() {
        return this.getItem(1);
    }

    public ItemStack getItem(int qty) {
        if (BlockDetector.getBlock() == null) {
            return null;
        }
        return new ItemStack((Block)BlockDetector.getBlock(), qty, this.ordinal());
    }

    public boolean isEnabled() {
        return BlockDetector.getBlock() != null && ModuleManager.isModuleLoaded(this.module);
    }

    static {
        VALUES = EnumDetector.values();
    }
}

