/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.detector.Detector;
import mods.railcraft.common.blocks.signals.ISecure;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.LockButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public abstract class DetectorSecured
extends Detector
implements IGuiReturnHandler,
ISecure {
    private final MultiButtonController<LockButtonState> lockController = new MultiButtonController(0, (IMultiButtonState[])LockButtonState.VALUES);

    @Override
    public MultiButtonController<LockButtonState> getLockController() {
        return this.lockController;
    }

    @Override
    public float getHardness() {
        if (this.isSecure()) {
            return -1.0f;
        }
        return super.getHardness();
    }

    @Override
    public boolean isSecure() {
        return this.lockController.getButtonState() == LockButtonState.LOCKED;
    }

    private boolean canAccess(String username) {
        return !this.isSecure() || MiscTools.isOwnerOrOp(this.getOwner(), username);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.lockController.writeToNBT(data, "lock");
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.lockController.readFromNBT(data, "lock");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.lockController.getCurrentState());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.lockController.setCurrentState(data.readByte());
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.lockController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        byte lock = data.readByte();
        if (sender == null || this.canAccess(Railcraft.proxy.getPlayerIdentifier(sender))) {
            this.lockController.setCurrentState(lock);
        }
    }

    @Override
    public String getName() {
        return this.tile.getName();
    }

    @Override
    public String getOwner() {
        return this.tile.getOwner();
    }
}

