/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.slab;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.aesthetics.EnumBlockMaterial;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class TileSlab
extends RailcraftTileEntity {
    private EnumBlockMaterial top = null;
    private EnumBlockMaterial bottom = null;

    public boolean canUpdate() {
        return false;
    }

    public IIcon getTexture(int side) {
        if (this.bottom != null) {
            return this.bottom.getIcon(side);
        }
        if (this.top != null) {
            return this.top.getIcon(side);
        }
        return EnumBlockMaterial.SANDY_BRICK.getIcon(side);
    }

    public void setTopSlab(EnumBlockMaterial slab) {
        if (this.top != slab) {
            this.top = slab;
            this.sendUpdateToClient();
        }
    }

    public void setBottomSlab(EnumBlockMaterial slab) {
        if (this.bottom != slab) {
            this.bottom = slab;
            this.sendUpdateToClient();
        }
    }

    public EnumBlockMaterial getTopSlab() {
        return this.top;
    }

    public EnumBlockMaterial getBottomSlab() {
        return this.bottom;
    }

    public boolean isDoubleSlab() {
        return this.top != null && this.bottom != null;
    }

    public boolean isTopSlab() {
        return this.top != null && this.bottom == null;
    }

    public boolean isBottomSlab() {
        return this.top == null && this.bottom != null;
    }

    public EnumBlockMaterial getUpmostSlab() {
        if (this.top != null) {
            return this.top;
        }
        return this.bottom;
    }

    public boolean addSlab(EnumBlockMaterial slab) {
        if (this.bottom == null) {
            this.setBottomSlab(slab);
            return true;
        }
        if (this.top == null) {
            this.setTopSlab(slab);
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        if (this.top != null) {
            data.func_74778_a("top", this.top.name());
        }
        if (this.bottom != null) {
            data.func_74778_a("bottom", this.bottom.name());
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("top")) {
            this.top = EnumBlockMaterial.fromName(data.func_74779_i("top"));
        }
        if (data.func_74764_b("bottom")) {
            this.bottom = EnumBlockMaterial.fromName(data.func_74779_i("bottom"));
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte((byte)(this.top != null ? this.top.ordinal() : -1));
        data.writeByte((byte)(this.bottom != null ? this.bottom.ordinal() : -1));
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        byte t = data.readByte();
        this.top = t != -1 ? EnumBlockMaterial.fromOrdinal(t) : null;
        byte b = data.readByte();
        this.bottom = b != -1 ? EnumBlockMaterial.fromOrdinal(b) : null;
        this.markBlockForUpdate();
    }

    @Override
    public short getId() {
        return 43;
    }
}

