/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.post;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePostEmblem
extends RailcraftTileEntity {
    private ForgeDirection facing = ForgeDirection.NORTH;
    private String emblem = "";
    private EnumColor color = null;

    public void setFacing(ForgeDirection f) {
        switch (f) {
            case UP: 
            case DOWN: 
            case UNKNOWN: {
                return;
            }
        }
        if (f != this.facing) {
            this.facing = f;
            this.markBlockForUpdate();
        }
    }

    public ForgeDirection getFacing() {
        return this.facing;
    }

    public void setEmblem(String identifier) {
        if (!this.emblem.equals(identifier)) {
            this.emblem = identifier;
            this.sendUpdateToClient();
        }
    }

    public String getEmblem() {
        return this.emblem;
    }

    public void setColor(EnumColor color) {
        if (this.color != color) {
            this.color = color;
            this.sendUpdateToClient();
        }
    }

    public EnumColor getColor() {
        return this.color;
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74778_a("emblem", this.emblem);
        data.func_74774_a("facing", (byte)this.facing.ordinal());
        if (this.color != null) {
            data.func_74774_a("color", (byte)this.color.ordinal());
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.emblem = data.func_74779_i("emblem");
        this.facing = ForgeDirection.getOrientation((int)data.func_74771_c("facing"));
        if (data.func_74764_b("color")) {
            this.color = EnumColor.fromId(data.func_74771_c("color"));
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte((byte)this.facing.ordinal());
        data.writeByte((byte)(this.color != null ? this.color.ordinal() : -1));
        data.writeUTF(this.emblem);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        byte cByte;
        super.readPacketData(data);
        boolean needsUpdate = false;
        ForgeDirection f = ForgeDirection.getOrientation((int)data.readByte());
        if (this.facing != f) {
            this.facing = f;
            needsUpdate = true;
        }
        if ((cByte = data.readByte()) < 0) {
            if (this.color != null) {
                this.color = null;
                needsUpdate = true;
            }
        } else {
            EnumColor c = EnumColor.fromId(cByte);
            if (this.color != c) {
                this.color = c;
                needsUpdate = true;
            }
        }
        this.emblem = data.readUTF();
        if (needsUpdate) {
            this.markBlockForUpdate();
        }
    }

    @Override
    public String getName() {
        return "Emblem Post";
    }

    @Override
    public short getId() {
        return (short)EnumPost.EMBLEM.ordinal();
    }
}

