/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.cube;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import mods.railcraft.common.blocks.aesthetics.cube.CrushedObsidian;
import mods.railcraft.common.blocks.aesthetics.cube.FlammableCube;
import mods.railcraft.common.blocks.aesthetics.cube.ReplacerCube;
import mods.railcraft.common.blocks.aesthetics.cube.SimpleCube;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.modules.ModuleManager;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public enum EnumCube {
    COKE_BLOCK(ModuleManager.Module.FACTORY, "coke", new SimpleCube(), 2.0f, 10.0f),
    CONCRETE_BLOCK(ModuleManager.Module.STRUCTURES, "concrete", new SimpleCube(), 3.0f, 15.0f),
    STEEL_BLOCK(ModuleManager.Module.FACTORY, "steel", new SimpleCube(), 5.0f, 15.0f),
    INFERNAL_BRICK(ModuleManager.Module.STRUCTURES, "brick.infernal", new ReplacerCube(), 3.0f, 15.0f),
    CRUSHED_OBSIDIAN(ModuleManager.Module.FACTORY, "crushed.obsidian", new CrushedObsidian(), 2.0f, 45.0f),
    SANDY_BRICK(ModuleManager.Module.STRUCTURES, "brick.sandy", new ReplacerCube(), 2.0f, 10.0f),
    ABYSSAL_STONE(ModuleManager.Module.WORLD, "stone.abyssal", new SimpleCube(), 2.0f, 10.0f),
    QUARRIED_STONE(ModuleManager.Module.WORLD, "stone.quarried", new SimpleCube(), 2.0f, 10.0f),
    CREOSOTE_BLOCK(ModuleManager.Module.STRUCTURES, "creosote", new FlammableCube(5, 300), 3.0f, 15.0f);

    public static final EnumCube[] VALUES;
    private final ModuleManager.Module module;
    private final String tag;
    private final SimpleCube block;
    private final float hardness;
    private final float resistance;
    private IIcon icon;
    private static final List<EnumCube> creativeList;

    private EnumCube(ModuleManager.Module module, String tag, SimpleCube block, float hardness, float resistance) {
        this.module = module;
        this.tag = tag;
        this.block = block;
        this.hardness = hardness;
        this.resistance = resistance;
    }

    public static List<EnumCube> getCreativeList() {
        return creativeList;
    }

    public ModuleManager.Module getModule() {
        return this.module;
    }

    public String getTag() {
        return "railcraft.cube." + this.tag;
    }

    public SimpleCube getBlock() {
        return this.block;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getResistance() {
        return this.resistance;
    }

    public boolean isEnabled() {
        return this.getModule() != null && ModuleManager.isModuleLoaded(this.getModule()) && RailcraftConfig.isSubBlockEnabled(this.getTag()) && BlockCube.getBlock() != null;
    }

    public static EnumCube fromOrdinal(int id) {
        if (id < 0 || id >= VALUES.length) {
            return CONCRETE_BLOCK;
        }
        return VALUES[id];
    }

    public ItemStack getItem() {
        return this.getItem(1);
    }

    public ItemStack getItem(int qty) {
        if (BlockCube.getBlock() == null) {
            return null;
        }
        return new ItemStack((Block)BlockCube.getBlock(), qty, this.ordinal());
    }

    public void setIcon(IIcon tex) {
        this.icon = tex;
    }

    public IIcon getIcon() {
        return this.icon;
    }

    static {
        VALUES = EnumCube.values();
        creativeList = new ArrayList<EnumCube>();
        creativeList.add(COKE_BLOCK);
        creativeList.add(STEEL_BLOCK);
        creativeList.add(CONCRETE_BLOCK);
        creativeList.add(CREOSOTE_BLOCK);
        creativeList.add(CRUSHED_OBSIDIAN);
        creativeList.add(ABYSSAL_STONE);
        creativeList.add(QUARRIED_STONE);
    }
}

