/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.brick;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.aesthetics.brick.ItemBrick;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.cube.ReplacerCube;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.misc.MicroBlockPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class BlockBrick
extends Block {
    public static BlockBrick infernal;
    public static BlockBrick abyssal;
    public static BlockBrick sandy;
    public static BlockBrick frostbound;
    public static BlockBrick bloodstained;
    public static BlockBrick quarried;
    public static BlockBrick bleachedbone;
    public static BlockBrick nether;
    private IIcon[] icons;
    private final String theme;

    public static BlockBrick getBlock() {
        return infernal;
    }

    public static void setupBlock() {
        IRockCrusherRecipe recipe;
        if (infernal == null) {
            infernal = BlockBrick.defineBrick("infernal");
            ((ReplacerCube)EnumCube.INFERNAL_BRICK.getBlock()).block = infernal;
            CraftingPlugin.addShapedRecipe(new ItemStack((Block)infernal, 2, 2), "MB", "BM", Character.valueOf('B'), new ItemStack(Blocks.field_150385_bj), Character.valueOf('M'), new ItemStack(Blocks.field_150425_aM));
        }
        if (abyssal == null) {
            abyssal = BlockBrick.defineBrick("abyssal");
            if (EnumCube.ABYSSAL_STONE.isEnabled()) {
                CraftingPlugin.addFurnaceRecipe(EnumCube.ABYSSAL_STONE.getItem(), new ItemStack((Block)abyssal, 1, 2), 0.2f);
                recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(EnumCube.ABYSSAL_STONE.getItem(), true, false);
                recipe.addOutput(abyssal.getItemStack(BrickVariant.COBBLE, 1), 1.0f);
            }
        }
        if (sandy == null) {
            sandy = BlockBrick.defineBrick("sandy");
            ((ReplacerCube)EnumCube.SANDY_BRICK.getBlock()).block = sandy;
            CraftingPlugin.addShapedRecipe(new ItemStack((Block)sandy, 1, 2), "BM", "MB", Character.valueOf('B'), new ItemStack(Items.field_151118_aC), Character.valueOf('M'), new ItemStack(Blocks.field_150354_m));
        }
        if (frostbound == null) {
            frostbound = BlockBrick.defineBrick("frostbound");
            CraftingPlugin.addShapedRecipe(new ItemStack((Block)frostbound, 8, 2), "III", "ILI", "III", Character.valueOf('I'), new ItemStack(Blocks.field_150432_aD), Character.valueOf('L'), new ItemStack(Items.field_151100_aR, 1, 4));
        }
        if (quarried == null) {
            quarried = BlockBrick.defineBrick("quarried");
            if (EnumCube.QUARRIED_STONE.isEnabled()) {
                CraftingPlugin.addFurnaceRecipe(EnumCube.QUARRIED_STONE.getItem(), new ItemStack((Block)quarried, 1, 2), 0.2f);
                recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(EnumCube.QUARRIED_STONE.getItem(), true, false);
                recipe.addOutput(quarried.getItemStack(BrickVariant.COBBLE, 1), 1.0f);
            }
        }
        if (bleachedbone == null) {
            bleachedbone = BlockBrick.defineBrick("bleachedbone");
            CraftingPlugin.addShapedRecipe(new ItemStack((Block)bleachedbone, 1, 2), "BM", "MB", Character.valueOf('B'), new ItemStack(Items.field_151118_aC), Character.valueOf('M'), new ItemStack(Items.field_151100_aR, 1, 15));
        }
        if (bloodstained == null) {
            bloodstained = BlockBrick.defineBrick("bloodstained");
            CraftingPlugin.addShapelessRecipe(new ItemStack((Block)bloodstained, 1, 2), new ItemStack(Blocks.field_150322_A, 1, 2), new ItemStack(Items.field_151078_bh));
            CraftingPlugin.addShapelessRecipe(new ItemStack((Block)bloodstained, 1, 2), new ItemStack(Blocks.field_150322_A, 1, 2), new ItemStack(Items.field_151082_bd));
        }
        if (nether == null) {
            nether = BlockBrick.defineBrick("nether");
            CraftingPlugin.addFurnaceRecipe(new ItemStack(Blocks.field_150385_bj), nether.getItemStack(BrickVariant.BLOCK, 1), 0.0f);
        }
    }

    private static BlockBrick makeBrick(String theme) {
        if (theme.equals("nether")) {
            return new BlockNetherBrick();
        }
        return new BlockBrick(theme);
    }

    private static BlockBrick defineBrick(String theme) {
        if (RailcraftConfig.isBlockEnabled("brick." + theme)) {
            BlockBrick block = BlockBrick.makeBrick(theme);
            block.func_149663_c("railcraft.brick." + theme);
            GameRegistry.registerBlock((Block)block, ItemBrick.class, (String)block.func_149739_a());
            for (BrickVariant variant : BrickVariant.VALUES) {
                block.initVarient(variant);
            }
            CraftingPlugin.addShapelessRecipe(block.getItemStack(BrickVariant.BRICK, 1), block.getItemStack(BrickVariant.FITTED, 1));
            CraftingPlugin.addShapelessRecipe(block.getItemStack(BrickVariant.FITTED, 1), block.getItemStack(BrickVariant.BLOCK, 1));
            CraftingPlugin.addShapedRecipe(block.getItemStack(BrickVariant.ORNATE, 8), "III", "I I", "III", Character.valueOf('I'), block.getItemStack(BrickVariant.BLOCK, 1));
            CraftingPlugin.addShapelessRecipe(block.getItemStack(BrickVariant.ETCHED, 1), block.getItemStack(BrickVariant.BLOCK, 1), new ItemStack(Items.field_151016_H));
            IRockCrusherRecipe recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(new ItemStack((Block)block), false, false);
            recipe.addOutput(block.getItemStack(BrickVariant.COBBLE, 1), 1.0f);
            CraftingPlugin.addFurnaceRecipe(block.getItemStack(BrickVariant.COBBLE, 1), block.getItemStack(BrickVariant.BLOCK, 1), 0.0f);
            return block;
        }
        return null;
    }

    public BlockBrick(String theme) {
        super(Material.field_151576_e);
        this.theme = theme;
        this.func_149752_b(15.0f);
        this.func_149711_c(5.0f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149647_a(CreativePlugin.RAILCRAFT_TAB);
        this.setHarvestLevel("pickaxe", 0);
    }

    protected void initVarient(BrickVariant variant) {
        ForestryPlugin.addBackpackItem("builder", this.getItemStack(variant, 1));
        MicroBlockPlugin.addMicroBlockCandidate(this, variant.ordinal());
        RailcraftLanguage.instance().registerItemName(this.getItemStack(variant, 1), "brick." + this.theme + "." + (Object)((Object)variant));
    }

    public ItemStack getItemStack(BrickVariant v, int qty) {
        return new ItemStack((Block)this, qty, v.ordinal());
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:brick." + this.theme, BrickVariant.VALUES.length);
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta >= this.icons.length) {
            meta = 0;
        }
        return this.icons[meta];
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (BrickVariant variant : BrickVariant.VALUES) {
            list.add(this.getItemStack(variant, 1));
        }
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    private static class BlockNetherBrick
    extends BlockBrick {
        public BlockNetherBrick() {
            super("nether");
        }

        @Override
        protected void initVarient(BrickVariant variant) {
            if (variant != BrickVariant.BRICK) {
                super.initVarient(variant);
            }
        }

        @Override
        public ItemStack getItemStack(BrickVariant v, int qty) {
            if (v == BrickVariant.BRICK) {
                return new ItemStack(Blocks.field_150385_bj, qty);
            }
            return super.getItemStack(v, qty);
        }
    }

    public static enum BrickVariant {
        BRICK,
        FITTED,
        BLOCK,
        ORNATE,
        ETCHED,
        COBBLE;

        public static final BrickVariant[] VALUES;

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        static {
            VALUES = BrickVariant.values();
        }
    }
}

