/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class EntityFireSparkFX
extends EntityFX {
    private float lavaParticleScale;
    private final double endX;
    private final double endY;
    private final double endZ;
    private final double maxDist;

    public EntityFireSparkFX(World world, double x, double y, double z, double endX, double endY, double endZ) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.endX = endX;
        this.endY = endY;
        this.endZ = endZ;
        this.maxDist = this.func_70092_e(endX, endY, endZ);
        this.calculateVector(this.maxDist);
        this.func_70541_f(0.5f);
        this.field_70551_j = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70552_h = 1.0f;
        this.field_70544_f *= this.field_70146_Z.nextFloat() * 2.0f + 0.2f;
        this.lavaParticleScale = this.field_70544_f;
        this.field_70547_e = 2000;
        this.field_70145_X = true;
        this.func_70536_a(49);
    }

    private void calculateVector(double dist) {
        Vec3 endPoint = Vec3.func_72443_a((double)this.endX, (double)this.endY, (double)this.endZ);
        Vec3 vecParticle = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 vel = vecParticle.func_72444_a(endPoint);
        vel = vel.func_72432_b();
        float velScale = 0.1f;
        this.field_70159_w = vel.field_72450_a * (double)velScale;
        this.field_70181_x = vel.field_72448_b * (double)velScale + 0.2 * (dist / this.maxDist);
        this.field_70179_y = vel.field_72449_c * (double)velScale;
    }

    public int func_70070_b(float par1) {
        int brightness = super.func_70070_b(par1);
        int short1 = 240;
        int j = brightness >> 16 & 0xFF;
        return short1 | j << 16;
    }

    public float func_70013_c(float par1) {
        return 1.0f;
    }

    public void func_70539_a(Tessellator par1Tessellator, float par2, float par3, float par4, float par5, float par6, float par7) {
        float f6 = ((float)this.field_70546_d + par2) / (float)this.field_70547_e;
        this.field_70544_f = this.lavaParticleScale * (1.0f - f6 * f6);
        super.func_70539_a(par1Tessellator, par2, par3, par4, par5, par6, par7);
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
            return;
        }
        double dist = this.func_70092_e(this.endX, this.endY, this.endZ);
        if (dist <= 0.1) {
            this.func_70106_y();
            return;
        }
        this.calculateVector(dist);
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }
}

