/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiToggleButton;
import mods.railcraft.common.blocks.machine.gamma.TileEnergyLoader;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.containers.ContainerEnergyLoader;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;

public class GuiLoaderEnergy
extends TileGui {
    private static final String BUTTON1 = RailcraftLanguage.translate("gui.energy.loader.empty");
    private static final String BUTTON2 = RailcraftLanguage.translate("gui.energy.loader.fill");
    private TileEnergyLoader tile;
    private boolean waitIfEmpty;
    private boolean waitTillFull;

    public GuiLoaderEnergy(InventoryPlayer inv, TileEnergyLoader tile) {
        super(tile, new ContainerEnergyLoader(inv, tile), "railcraft:textures/gui/gui_energy_loader.png");
        this.tile = tile;
        this.waitIfEmpty = tile.waitIfEmpty();
        this.waitTillFull = tile.waitTillFull();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.tile == null) {
            return;
        }
        this.field_146292_n.clear();
        int w = (this.field_146294_l - this.field_146999_f) / 2;
        int h = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiToggleButton(0, w + 75, h + 18, 70, BUTTON1, this.waitIfEmpty));
        this.field_146292_n.add(new GuiToggleButton(1, w + 75, h + 42, 70, BUTTON2, this.waitTillFull));
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (this.tile == null) {
            return;
        }
        if (guibutton.field_146127_k == 0) {
            boolean bl = this.waitIfEmpty = !this.waitIfEmpty;
            if (!this.waitIfEmpty) {
                this.waitTillFull = false;
            }
            ((GuiToggleButton)guibutton).active = this.waitIfEmpty;
            ((GuiToggleButton)((Object)this.field_146292_n.get((int)1))).active = this.waitTillFull;
        }
        if (guibutton.field_146127_k == 1) {
            boolean bl = this.waitTillFull = !this.waitTillFull;
            if (this.waitTillFull) {
                this.waitIfEmpty = true;
            }
            ((GuiToggleButton)((Object)this.field_146292_n.get((int)0))).active = this.waitIfEmpty;
            ((GuiToggleButton)guibutton).active = this.waitTillFull;
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int sWidth = this.field_146289_q.func_78256_a(this.tile.getName());
        int sPos = this.field_146999_f / 2 - sWidth / 2;
        this.field_146289_q.func_78276_b(this.tile.getName(), sPos, 6, 0x404040);
        this.field_146289_q.func_78276_b(Integer.toString(this.tile.getEnergy()), 30, 55, 0x404040);
        StringBuilder capacity = new StringBuilder("/").append(this.tile.getCapacity());
        this.field_146289_q.func_78276_b(capacity.toString(), 28, 65, 0x404040);
        this.field_146289_q.func_78276_b("Rate: " + this.tile.getTransferRate(), 90, 67, 0x404040);
    }

    @Override
    protected void func_146976_a(float f, int i, int j) {
        super.func_146976_a(f, i, j);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.tile.getEnergy() > 0) {
            int energy = this.tile.getEnergyBarScaled(24);
            this.func_73729_b(x + 31, y + 34, 176, 14, energy, 17);
        }
    }

    public void func_146281_b() {
        if (Game.isNotHost(this.tile.getWorld())) {
            this.tile.setWaitIfEmpty(this.waitIfEmpty);
            this.tile.setWaitTillFull(this.waitTillFull);
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendToServer(pkt);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        TileEntity t = this.tile.getWorld().func_147438_o(this.tile.getX(), this.tile.getY(), this.tile.getZ());
        if (t instanceof TileEnergyLoader) {
            this.tile = (TileEnergyLoader)t;
        } else {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }
}

