/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import java.awt.Desktop;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiButtonSmall;
import mods.railcraft.common.blocks.machine.alpha.TileEngravingBench;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.containers.ContainerEngravingBenchUnlock;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class GuiEngravingBenchUnlock
extends TileGui {
    private static final String URL_BLOG = "http://railcraft.info/";
    private static final String URL_TWITTER = "https://twitter.com/CovertJaguar";
    private static final String URL_YOUTUBE = "https://www.youtube.com/user/CovertJaguar";
    private final TileEngravingBench tile;
    private final EntityPlayer player;
    private boolean pause = false;
    private String code = "";
    private int updateCount;

    public GuiEngravingBenchUnlock(InventoryPlayer inv, TileEngravingBench tile) {
        super(tile, new ContainerEngravingBenchUnlock(inv, tile), "railcraft:textures/gui/gui_engraving_unlock.png");
        this.tile = tile;
        this.player = inv.field_70458_d;
        this.field_147000_g = 215;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int w = (this.field_146294_l - this.field_146999_f) / 2;
        int h = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiButtonSmall(0, w + 16, h + 77, 50, StatCollector.func_74838_a((String)"gui.engrave.unlock")));
        this.field_146292_n.add(new GuiButtonSmall(1, w + this.field_146999_f - 58, h + this.field_147000_g - 23, 50, StatCollector.func_74838_a((String)"gui.back")));
        this.field_146292_n.add(new GuiButtonSmall(2, w + 24, h + 146, 128, "The Railcraft Blog"));
        ArrayList<GuiButtonSmall> buttons = new ArrayList<GuiButtonSmall>();
        buttons.add(new GuiButtonSmall(3, 0, h + 162, 80, "CJ's Twitter"));
        buttons.add(new GuiButtonSmall(4, 0, h + 162, 80, "CJ's Youtube"));
        GuiTools.newButtonRow(this.field_146292_n, w + 7, 2, buttons);
    }

    protected void func_73869_a(char c, int key) {
        switch (key) {
            case 14: {
                if (this.code.length() > 0) {
                    this.code = this.code.substring(0, this.code.length() - 1);
                }
                return;
            }
            case 28: {
                this.attemptUnlock();
                return;
            }
            case 1: 
            case 15: {
                this.sendUpdateToTile(TileEngravingBench.GuiPacketType.OPEN_NORMAL);
                return;
            }
        }
        if (this.code.length() < 24 && ChatAllowedCharacters.func_71566_a((char)c)) {
            this.code = this.code + Character.toString(c);
        }
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        this.pause = false;
        switch (button.field_146127_k) {
            case 0: {
                this.attemptUnlock();
                break;
            }
            case 1: {
                this.sendUpdateToTile(TileEngravingBench.GuiPacketType.OPEN_NORMAL);
                break;
            }
            case 2: {
                this.openLink(URL_BLOG);
                break;
            }
            case 3: {
                this.openLink(URL_TWITTER);
                break;
            }
            case 4: {
                this.openLink(URL_YOUTUBE);
            }
        }
    }

    private void attemptUnlock() {
        if (this.code.length() > 0) {
            this.sendUpdateToTile(TileEngravingBench.GuiPacketType.UNLOCK_EMBLEM);
        }
    }

    private void openLink(String url) {
        this.pause = true;
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendUpdateToTile(TileEngravingBench.GuiPacketType type) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeByte(type.ordinal());
            switch (type) {
                case UNLOCK_EMBLEM: {
                    data.writeByte(this.container.field_75152_c);
                    data.writeUTF(this.code.toLowerCase(Locale.ENGLISH));
                }
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        PacketBuilder.instance().sendGuiReturnPacket(this.tile, bytes.toByteArray());
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GuiTools.drawCenteredString(this.field_146289_q, this.tile.getName(), 6);
        GuiTools.drawCenteredString(this.field_146289_q, RailcraftLanguage.translate("gui.engrave.entercode"), 28);
        String codeDisplay = this.code;
        codeDisplay = this.updateCount / 6 % 2 == 0 ? codeDisplay + "" + EnumChatFormatting.GRAY + "_" : codeDisplay + "" + EnumChatFormatting.WHITE + "_";
        this.field_146289_q.func_85187_a(codeDisplay, 13, 50, 0xFFFFFF, false);
        String unlockMsg = ((ContainerEngravingBenchUnlock)this.container).unlockMsg;
        int msgColor = 0x404040;
        if (unlockMsg != null && !unlockMsg.equals("")) {
            if (unlockMsg.equals("gui.engrave.unlock.fail")) {
                msgColor = 0xFF0000;
            }
            this.field_146289_q.func_78276_b(RailcraftLanguage.translate(unlockMsg), 72, 81, msgColor);
        }
        GuiTools.drawCenteredString(this.field_146289_q, RailcraftLanguage.translate("gui.engrave.getmore1"), 114);
        GuiTools.drawCenteredString(this.field_146289_q, RailcraftLanguage.translate("gui.engrave.getmore2"), 130);
    }

    public boolean func_73868_f() {
        return this.pause;
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.updateCount;
    }
}

