/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signals;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.SignalTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public abstract class AbstractPair {
    private static final int SAFE_TIME = 32;
    private static final int PAIR_CHECK_INTERVAL = 128;
    protected static final Random rand = new Random();
    public final TileEntity tile;
    private WorldCoordinate coords;
    public final String name;
    public final int maxPairings;
    private boolean isBeingPaired;
    protected Deque<WorldCoordinate> pairings = new LinkedList<WorldCoordinate>();
    protected Set<WorldCoordinate> invalidPairings = new HashSet<WorldCoordinate>();
    private int update = rand.nextInt();
    private int ticksExisted;
    private boolean needsInit = true;

    public AbstractPair(String name, TileEntity tile, int maxPairings) {
        this.tile = tile;
        this.maxPairings = maxPairings;
        this.name = name;
    }

    protected void addPairing(WorldCoordinate other) {
        this.pairings.add(other);
        while (this.pairings.size() > this.getMaxPairings()) {
            this.pairings.remove();
        }
        SignalTools.packetBuilder.sendPairPacketUpdate(this);
    }

    public void clearPairing(WorldCoordinate other) {
        this.invalidPairings.add(other);
    }

    public void endPairing() {
        this.isBeingPaired = false;
    }

    public void tickClient() {
        if (this.needsInit) {
            this.needsInit = false;
            SignalTools.packetBuilder.sendPairPacketRequest(this);
        }
    }

    public void tickServer() {
        ++this.ticksExisted;
        ++this.update;
        if (this.ticksExisted >= 32 && this.update % 128 == 0) {
            this.validatePairings();
        }
    }

    protected void validatePairings() {
        for (WorldCoordinate coord : this.pairings) {
            this.getPairAt(coord);
        }
        this.cleanPairings();
    }

    public void cleanPairings() {
        boolean changed = this.pairings.removeAll(this.invalidPairings);
        this.invalidPairings.clear();
        if (changed) {
            SignalTools.packetBuilder.sendPairPacketUpdate(this);
        }
    }

    protected TileEntity getPairAt(WorldCoordinate coord) {
        if (!this.pairings.contains(coord)) {
            return null;
        }
        if (coord.y < 0) {
            this.clearPairing(coord);
            return null;
        }
        int x = coord.x;
        int y = coord.y;
        int z = coord.z;
        if (!this.tile.func_145831_w().func_72899_e(x, y, z)) {
            return null;
        }
        TileEntity target = this.tile.func_145831_w().func_147438_o(x, y, z);
        if (this.isValidPair(target)) {
            return target;
        }
        this.clearPairing(coord);
        return null;
    }

    public abstract boolean isValidPair(TileEntity var1);

    public WorldCoordinate getCoords() {
        if (this.coords == null) {
            this.coords = new WorldCoordinate(this.tile.func_145831_w().field_73011_w.field_76574_g, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e);
        }
        return this.coords;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxPairings() {
        return this.maxPairings;
    }

    public int getNumPairs() {
        return this.pairings.size();
    }

    public boolean isPaired() {
        return !this.pairings.isEmpty();
    }

    public Collection<WorldCoordinate> getPairs() {
        return Collections.unmodifiableCollection(this.pairings);
    }

    public TileEntity getTile() {
        return this.tile;
    }

    public void startPairing() {
        this.isBeingPaired = true;
    }

    public boolean isBeingPaired() {
        return this.isBeingPaired;
    }

    public boolean isPairedWith(WorldCoordinate other) {
        return this.pairings.contains(other);
    }

    protected abstract String getTagName();

    public final void writeToNBT(NBTTagCompound data) {
        NBTTagCompound tag = new NBTTagCompound();
        this.saveNBT(tag);
        data.func_74782_a(this.getTagName(), (NBTBase)tag);
    }

    protected void saveNBT(NBTTagCompound data) {
        NBTTagList list = new NBTTagList();
        for (WorldCoordinate c : this.pairings) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74783_a("coords", new int[]{c.dimension, c.x, c.y, c.z});
            list.func_74742_a((NBTBase)tag);
        }
        data.func_74782_a("pairings", (NBTBase)list);
    }

    public final void readFromNBT(NBTTagCompound data) {
        NBTTagCompound tag = data.func_74775_l(this.getTagName());
        this.loadNBT(tag);
    }

    protected void loadNBT(NBTTagCompound data) {
        NBTTagList list = data.func_150295_c("pairings", 10);
        for (int entry = 0; entry < list.func_74745_c(); entry = (int)((byte)(entry + 1))) {
            NBTTagCompound tag = list.func_150305_b(entry);
            int[] c = tag.func_74759_k("coords");
            this.pairings.add(new WorldCoordinate(c[0], c[1], c[2], c[3]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addPair(int x, int y, int z) {
        this.pairings.add(new WorldCoordinate(this.tile.func_145831_w().field_73011_w.field_76574_g, x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void removePair(int x, int y, int z) {
        this.pairings.remove(new WorldCoordinate(this.tile.func_145831_w().field_73011_w.field_76574_g, x, y, z));
    }

    public void clearPairings() {
        this.pairings.clear();
        if (!this.tile.func_145831_w().field_72995_K) {
            SignalTools.packetBuilder.sendPairPacketUpdate(this);
        }
    }
}

