/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class DataTools {
    public static void writeItemStack(ItemStack stack, DataOutputStream dataStream) throws IOException {
        if (stack == null) {
            dataStream.writeShort(-1);
        } else {
            dataStream.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            dataStream.writeByte(stack.field_77994_a);
            dataStream.writeShort(stack.func_77960_j());
            NBTTagCompound nbt = null;
            if (stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) {
                nbt = stack.field_77990_d;
            }
            DataTools.writeNBT(nbt, dataStream);
        }
    }

    public static ItemStack readItemStack(DataInputStream dataStream) throws IOException {
        ItemStack stack = null;
        short id = dataStream.readShort();
        if (id >= 0) {
            byte stackSize = dataStream.readByte();
            short damage = dataStream.readShort();
            stack = new ItemStack(Item.func_150899_d((int)id), (int)stackSize, (int)damage);
            stack.field_77990_d = DataTools.readNBT(dataStream);
        }
        return stack;
    }

    public static void writeNBT(NBTTagCompound nbt, DataOutputStream dataStream) throws IOException {
        if (nbt == null) {
            dataStream.writeShort(-1);
        } else {
            byte[] nbtData = CompressedStreamTools.func_74798_a((NBTTagCompound)nbt);
            dataStream.writeShort((short)nbtData.length);
            dataStream.write(nbtData);
        }
    }

    public static NBTTagCompound readNBT(DataInputStream dataStream) throws IOException {
        short lenght = dataStream.readShort();
        if (lenght < 0) {
            return null;
        }
        byte[] nbtData = new byte[lenght];
        dataStream.read(nbtData);
        return CompressedStreamTools.func_74792_a((byte[])nbtData);
    }
}

