/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.crafting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mods.railcraft.api.crafting.IBlastFurnaceCraftingManager;
import mods.railcraft.api.crafting.IBlastFurnaceRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.items.firestone.ItemFirestoneCracked;
import mods.railcraft.common.items.firestone.ItemFirestoneRefined;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class BlastFurnaceCraftingManager
implements IBlastFurnaceCraftingManager {
    private final List<BlastFurnaceRecipe> recipes = new ArrayList<BlastFurnaceRecipe>();
    private List<ItemStack> fuels;

    public static IBlastFurnaceCraftingManager getInstance() {
        return RailcraftCraftingManager.blastFurnace;
    }

    @Override
    public List<ItemStack> getFuels() {
        if (this.fuels == null) {
            ArrayList<ItemStack> fuel = new ArrayList<ItemStack>(){

                @Override
                public boolean add(ItemStack e) {
                    if (e == null) {
                        return false;
                    }
                    return super.add(e);
                }
            };
            fuel.add(RailcraftToolItems.getCoalCoke());
            fuel.add(EnumCube.COKE_BLOCK.getItem());
            fuel.add(new ItemStack(Items.field_151044_h, 1, 1));
            fuel.add(new ItemStack(ItemFirestoneRefined.item, 1, Short.MAX_VALUE));
            fuel.add(new ItemStack(ItemFirestoneCracked.item, 1, Short.MAX_VALUE));
            this.fuels = Collections.unmodifiableList(fuel);
        }
        return this.fuels;
    }

    @Override
    public List<? extends IBlastFurnaceRecipe> getRecipes() {
        return this.recipes;
    }

    @Override
    public void addRecipe(ItemStack input, boolean matchDamage, boolean matchNBT, int cookTime, ItemStack output) {
        if (input != null && output != null) {
            this.recipes.add(new BlastFurnaceRecipe(input, matchDamage, matchNBT, cookTime, output));
        }
    }

    @Override
    public IBlastFurnaceRecipe getRecipe(ItemStack input) {
        if (input == null) {
            return null;
        }
        for (BlastFurnaceRecipe r : this.recipes) {
            if (!r.matchDamage || InvTools.isWildcard(r.input) || !InvTools.isItemEqual(input, r.input, true, r.matchNBT)) continue;
            return r;
        }
        for (BlastFurnaceRecipe r : this.recipes) {
            if (!InvTools.isItemEqual(input, r.input, r.matchDamage, r.matchNBT)) continue;
            return r;
        }
        return null;
    }

    public static class BlastFurnaceRecipe
    implements IBlastFurnaceRecipe {
        private final ItemStack input;
        private final boolean matchDamage;
        private final boolean matchNBT;
        private final int cookTime;
        private final ItemStack output;

        public BlastFurnaceRecipe(ItemStack input, boolean matchDamage, boolean matchNBT, int cookTime, ItemStack output) {
            this.input = input.func_77946_l();
            this.matchDamage = matchDamage;
            this.matchNBT = matchNBT;
            this.cookTime = cookTime;
            this.output = output.func_77946_l();
        }

        @Override
        public boolean isRoomForOutput(ItemStack outputSlot) {
            return outputSlot == null || this.output == null || InvTools.isItemEqual(outputSlot, this.output) && outputSlot.field_77994_a + this.output.field_77994_a <= this.output.func_77976_d();
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public boolean matchDamage() {
            return this.matchDamage;
        }

        public boolean matchNBT() {
            return this.matchNBT;
        }

        @Override
        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        @Override
        public int getOutputStackSize() {
            if (this.output == null) {
                return 0;
            }
            return this.output.field_77994_a;
        }

        @Override
        public int getCookTime() {
            return this.cookTime;
        }
    }
}

