/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forge;

import cpw.mods.fml.common.registry.GameRegistry;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;

public class CraftingPlugin {
    public static void addFurnaceRecipe(ItemStack input, ItemStack output, float xp) {
        if (input == null && output == null) {
            Game.logTrace(Level.WARN, "Tried to define invalid furnace recipe, the input and output were both null. Skipping", new Object[0]);
            return;
        }
        if (input == null) {
            Game.logTrace(Level.WARN, "Tried to define invalid furnace recipe for {0}, the input was null. Skipping", output.func_77973_b().func_77658_a());
            return;
        }
        if (output == null) {
            Game.logTrace(Level.WARN, "Tried to define invalid furnace recipe for {0}, the output was null. Skipping", input.func_77973_b().func_77658_a());
            return;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(input, output, xp);
    }

    public static void addShapedRecipe(ItemStack result, Object ... input) {
        if (result == null || result.field_77994_a <= 0) {
            Game.logTrace(Level.WARN, "Tried to define invalid shaped recipe, the result was null or zero. Skipping", new Object[0]);
            return;
        }
        for (Object obj : input) {
            if (obj instanceof String) {
                if (((String)obj).length() <= 3) continue;
                throw new IllegalArgumentException("CJ you're a noob, you used the wrong function again!");
            }
            if (obj != null) continue;
            Game.logTrace(Level.WARN, "Tried to define invalid shaped recipe for {0}, a necessary item was probably disabled. Skipping", result.func_77973_b().func_77658_a());
            return;
        }
        GameRegistry.addRecipe((ItemStack)result, (Object[])input);
    }

    public static void addShapelessRecipe(ItemStack result, Object ... input) {
        if (result == null || result.field_77994_a <= 0) {
            Game.logTrace(Level.WARN, "Tried to define invalid shapeless recipe, the result was null or zero. Skipping", new Object[0]);
            return;
        }
        for (Object obj : input) {
            if (obj != null) continue;
            Game.logTrace(Level.WARN, "Tried to define invalid shapeless recipe for {0}, a necessary item was probably disabled. Skipping", result.func_77973_b().func_77658_a());
            return;
        }
        GameRegistry.addShapelessRecipe((ItemStack)result, (Object[])input);
    }

    public static void addShapedOreRecipe(ItemStack result, Object ... input) {
        if (result == null || result.field_77994_a <= 0) {
            Game.logTrace(Level.WARN, "Tried to define invalid shaped ore recipe, the result was null or zero. Skipping", new Object[0]);
            return;
        }
        for (Object obj : input) {
            if (obj != null) continue;
            Game.logTrace(Level.WARN, "Tried to define invalid shaped ore recipe for {0}, a necessary item was probably disabled. Skipping", result.func_77973_b().func_77658_a());
            return;
        }
        ShapedOreRecipe recipe = new ShapedOreRecipe(result, input);
        CraftingPlugin.addRecipe((IRecipe)recipe);
    }

    public static void addShapelessOreRecipe(ItemStack result, Object ... input) {
        if (result == null || result.field_77994_a <= 0) {
            Game.logTrace(Level.WARN, "Tried to define invalid shapeless ore recipe, the result was null or zero. Skipping", new Object[0]);
            return;
        }
        for (Object obj : input) {
            if (obj != null) continue;
            Game.logTrace(Level.WARN, "Tried to define invalid shapeless ore recipe for {0}, a necessary item was probably disabled. Skipping", result.func_77973_b().func_77658_a());
            return;
        }
        ShapelessOreRecipe recipe = new ShapelessOreRecipe(result, input);
        CraftingPlugin.addRecipe((IRecipe)recipe);
    }

    public static void addRecipe(IRecipe recipe) {
        GameRegistry.addRecipe((IRecipe)recipe);
    }
}

