/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forestry;

import forestry.api.storage.IBackpackDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class BaseBackpack
implements IBackpackDefinition {
    protected List<ItemStack> items = new ArrayList<ItemStack>(50);

    @Override
    public void addValidItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        this.items.add(stack);
    }

    public void addValidItem(Item item) {
        if (item == null) {
            return;
        }
        this.items.add(new ItemStack(item, 1, Short.MAX_VALUE));
    }

    public void addValidItem(Block block) {
        if (block == null) {
            return;
        }
        this.items.add(new ItemStack(block, 1, Short.MAX_VALUE));
    }

    @Override
    public Collection<ItemStack> getValidItems(EntityPlayer player) {
        return this.items;
    }

    @Override
    public boolean isValidItem(EntityPlayer player, ItemStack pickup) {
        for (ItemStack stack : this.items) {
            if (!InvTools.isItemEqualIgnoreNBT(stack, pickup)) continue;
            return true;
        }
        return false;
    }
}

