/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.craftguide;

import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.blocks.aesthetics.post.ItemPost;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ItemLocomotive;
import mods.railcraft.common.emblems.EmblemManager;
import mods.railcraft.common.emblems.ItemEmblem;
import mods.railcraft.common.items.ItemRoutingTable;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.items.ItemTicketGold;
import mods.railcraft.common.items.RailcraftPartItems;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.RecipeGenerator;
import uristqwerty.CraftGuide.api.RecipeProvider;
import uristqwerty.CraftGuide.api.RecipeTemplate;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;

public class CustomRecipesPlugin
implements RecipeProvider {
    private final Slot[] slots = new Slot[10];

    public CustomRecipesPlugin() {
        this.slots[0] = new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                this.slots[1 + x + y * 3] = new ItemSlot(3 + x * 18, 3 + y * 18, 16, 16, true).setSlotType(SlotType.INPUT_SLOT);
            }
        }
    }

    @Override
    public void generateRecipes(RecipeGenerator generator) {
        RecipeTemplate template = generator.createRecipeTemplate(this.slots, null, "/gui/CraftGuideRecipe.png", 1, 1, 82, 1);
        if (EnumMachineAlpha.TURBINE.isAvaliable()) {
            Object[] rotorRepair = new ItemStack[10];
            rotorRepair[0] = RailcraftPartItems.getTurbineRotor();
            rotorRepair[0].func_77964_b(1);
            for (int i = 0; i < 9; ++i) {
                rotorRepair[i + 1] = RailcraftPartItems.getTurbineBlade();
            }
            rotorRepair[5] = RailcraftPartItems.getTurbineRotor();
            rotorRepair[5].func_77964_b(25000);
            generator.addRecipe(template, rotorRepair);
        }
        if (ModuleManager.Module.ROUTING.isEnabled()) {
            Object[] ticket = new ItemStack[10];
            ticket[0] = ItemTicket.getTicket();
            ticket[1] = ItemTicketGold.getTicket();
            ticket[2] = new ItemStack(Items.field_151121_aF);
            NBTTagCompound nbt = InvTools.getItemData(ticket[0]);
            nbt.func_74778_a("owner", "CovertJaguar");
            nbt.func_74778_a("dest", "TheFarLands/Milliways");
            ticket[0].func_77982_d(nbt);
            ticket[1].func_77982_d(nbt);
            generator.addRecipe(template, ticket);
            Object[] routingTable = new ItemStack[10];
            routingTable[0] = ItemRoutingTable.getItem();
            routingTable[0].field_77994_a = 2;
            InvTools.addItemToolTip(routingTable[0], "Edited");
            routingTable[1] = ItemRoutingTable.getItem();
            InvTools.addItemToolTip(routingTable[1], "Edited");
            routingTable[2] = ItemRoutingTable.getItem();
            InvTools.addItemToolTip(routingTable[2], "Blank");
            generator.addRecipe(template, routingTable);
        }
        if (ModuleManager.Module.EMBLEM.isEnabled()) {
            Object[] stacks;
            if (EnumPost.EMBLEM.isEnabled()) {
                stacks = new ItemStack[10];
                stacks[0] = EnumPost.EMBLEM.getItem();
                ItemPost.setEmblem(stacks[0], EmblemManager.getIdentifierFromCode("Stone Age Miner"));
                stacks[1] = EnumPost.METAL.getItem();
                stacks[2] = ItemEmblem.getEmblem(EmblemManager.getIdentifierFromCode("Stone Age Miner"));
                generator.addRecipe(template, stacks);
            }
            if (EnumCart.LOCO_STEAM_SOLID.isEnabled()) {
                stacks = new ItemStack[10];
                stacks[0] = EnumCart.LOCO_STEAM_SOLID.getCartItem();
                ItemLocomotive.setEmblem(stacks[0], EmblemManager.getIdentifierFromCode("Stone Age Miner"));
                stacks[1] = EnumCart.LOCO_STEAM_SOLID.getCartItem();
                stacks[2] = ItemEmblem.getEmblem(EmblemManager.getIdentifierFromCode("Stone Age Miner"));
                generator.addRecipe(template, stacks);
            }
        }
    }
}

