/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.aesthetics.EnumBlockMaterial;
import mods.railcraft.common.blocks.aesthetics.brick.BlockBrick;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.glass.BlockStrengthGlass;
import mods.railcraft.common.blocks.aesthetics.lamp.BlockFactoryLamp;
import mods.railcraft.common.blocks.aesthetics.post.BlockPost;
import mods.railcraft.common.blocks.aesthetics.post.BlockPostMetal;
import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.blocks.aesthetics.slab.BlockFactorySlab;
import mods.railcraft.common.blocks.aesthetics.slab.BlockRailcraftSlab;
import mods.railcraft.common.blocks.aesthetics.stairs.BlockFactoryStairs;
import mods.railcraft.common.blocks.aesthetics.wall.BlockRailcraftWall;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.emblems.EmblemPostColorRecipe;
import mods.railcraft.common.emblems.EmblemPostEmblemRecipe;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.items.RailcraftPartItems;
import mods.railcraft.common.modules.AbstractModule;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.util.crafting.RollingMachineCraftingManager;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModuleStructures
extends AbstractModule {
    @Override
    public void preInit() {
        this.addBlockFactory(new BlockFactoryStairs());
        this.addBlockFactory(new BlockFactorySlab());
        this.addBlockFactory(new BlockFactoryLamp());
    }

    @Override
    public void initFirst() {
        ItemStack stack;
        BlockCube cube;
        RailcraftBlocks.registerBlockSignal();
        BlockPost.registerBlock();
        BlockPostMetal.registerPost();
        BlockPostMetal.registerPlatform();
        BlockRailcraftWall.registerBlocks();
        BlockStrengthGlass.registerBlock();
        BlockBrick.setupBlock();
        EnumCube cubeType = EnumCube.CONCRETE_BLOCK;
        if (RailcraftConfig.isSubBlockEnabled(cubeType.getTag())) {
            BlockCube.registerBlock();
            cube = BlockCube.getBlock();
            if (cube != null) {
                stack = cubeType.getItem();
                RailcraftLanguage.instance().registerItemName(stack, cubeType.getTag());
                if (ModuleManager.isModuleLoaded(ModuleManager.Module.FACTORY) && RailcraftBlocks.getBlockMachineAlpha() != null && RailcraftConfig.isSubBlockEnabled(EnumMachineAlpha.ROLLING_MACHINE.getTag())) {
                    stack.field_77994_a = 8;
                    CraftingPlugin.addShapedRecipe(stack, "SIS", "ISI", "SIS", Character.valueOf('I'), RailcraftPartItems.getRebar(), Character.valueOf('S'), Blocks.field_150348_b);
                } else {
                    stack.field_77994_a = 4;
                    CraftingPlugin.addShapedRecipe(stack, " S ", "SIS", " S ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('S'), Blocks.field_150348_b);
                }
            }
        }
        if (RailcraftConfig.isSubBlockEnabled((cubeType = EnumCube.CREOSOTE_BLOCK).getTag())) {
            BlockCube.registerBlock();
            cube = BlockCube.getBlock();
            if (cube != null) {
                stack = cubeType.getItem();
                RailcraftLanguage.instance().registerItemName(stack, cubeType.getTag());
                for (ItemStack container : FluidHelper.getContainersFilledWith(Fluids.CREOSOTE.get(1000))) {
                    CraftingPlugin.addShapelessOreRecipe(stack, "logWood", container);
                }
            }
        }
        RailcraftBlocks.registerBlockMachineAlpha();
        EnumMachineAlpha alpha = EnumMachineAlpha.SMOKER;
        if (RailcraftConfig.isSubBlockEnabled(alpha.getTag())) {
            stack = alpha.getItem();
            CraftingPlugin.addShapedRecipe(stack, " N ", "RCR", Character.valueOf('N'), new ItemStack(Blocks.field_150424_aL), Character.valueOf('C'), new ItemStack(Items.field_151066_bu), Character.valueOf('R'), new ItemStack(Items.field_151137_ax));
            RailcraftLanguage.instance().registerItemName(stack, alpha.getTag());
        }
        if (BlockStrengthGlass.getBlock() != null) {
            for (EnumColor color : EnumColor.VALUES) {
                CraftingPlugin.addShapedOreRecipe(BlockStrengthGlass.getItem(8, color.inverse().ordinal()), new Object[]{"GGG", "GDG", "GGG", Character.valueOf('G'), BlockStrengthGlass.getBlock(), Character.valueOf('D'), color.getDye()});
                RailcraftLanguage.instance().registerItemName(BlockStrengthGlass.getItem(color.ordinal()), "glass");
            }
        }
    }

    @Override
    public void initSecond() {
        ItemStack outputStack;
        ItemStack stackRaw;
        ItemStack stackColored;
        BlockRailcraftWall.initialize();
        BlockPost blockPost = BlockPost.block;
        if (blockPost != null) {
            if (ModuleManager.isModuleLoaded(ModuleManager.Module.EMBLEM)) {
                CraftingPlugin.addRecipe(new EmblemPostColorRecipe());
                CraftingPlugin.addRecipe(new EmblemPostEmblemRecipe());
            }
            CraftingPlugin.addShapelessRecipe(EnumPost.WOOD.getItem(4), RailcraftPartItems.getTieWood());
            CraftingPlugin.addShapedRecipe(EnumPost.WOOD_PLATFORM.getItem(), " T ", " I ", Character.valueOf('T'), BlockRailcraftSlab.getItem(EnumBlockMaterial.CREOSOTE), Character.valueOf('I'), EnumPost.WOOD.getItem());
            CraftingPlugin.addShapedRecipe(EnumPost.STONE.getItem(8), "SIS", "SIS", "SIS", Character.valueOf('I'), RailcraftPartItems.getRebar(), Character.valueOf('S'), Blocks.field_150348_b);
            CraftingPlugin.addShapedRecipe(EnumPost.STONE_PLATFORM.getItem(), " T ", " I ", Character.valueOf('T'), BlockRailcraftSlab.getItem(EnumBlockMaterial.CONCRETE), Character.valueOf('I'), EnumPost.STONE.getItem());
            ItemStack stack = EnumPost.METAL.getItem(16);
            RailcraftCraftingManager.rollingMachine.addRecipe(stack, "III", " I ", "III", Character.valueOf('I'), Items.field_151042_j);
            RailcraftCraftingManager.rollingMachine.addRecipe(stack, "I I", "III", "I I", Character.valueOf('I'), Items.field_151042_j);
            CraftingPlugin.addShapedRecipe(EnumPost.METAL_PLATFORM.getItem(4), " T ", " I ", Character.valueOf('T'), BlockRailcraftSlab.getItem(EnumBlockMaterial.IRON), Character.valueOf('I'), EnumPost.METAL.getItem());
            stack = EnumPost.METAL.getItem(32);
            ShapedOreRecipe recipe = new ShapedOreRecipe(stack, new Object[]{"III", " I ", "III", Character.valueOf('I'), "ingotSteel"});
            RollingMachineCraftingManager.getInstance().getRecipeList().add((IRecipe)recipe);
            recipe = new ShapedOreRecipe(stack, new Object[]{"I I", "III", "I I", Character.valueOf('I'), "ingotSteel"});
            RollingMachineCraftingManager.getInstance().getRecipeList().add((IRecipe)recipe);
            stack = EnumPost.METAL.getItem(12);
            recipe = new ShapedOreRecipe(stack, new Object[]{"III", " I ", "III", Character.valueOf('I'), "ingotBronze"});
            RollingMachineCraftingManager.getInstance().getRecipeList().add((IRecipe)recipe);
            recipe = new ShapedOreRecipe(stack, new Object[]{"I I", "III", "I I", Character.valueOf('I'), "ingotBronze"});
            RollingMachineCraftingManager.getInstance().getRecipeList().add((IRecipe)recipe);
            stack = EnumPost.METAL.getItem(20);
            recipe = new ShapedOreRecipe(stack, new Object[]{"III", " I ", "III", Character.valueOf('I'), "ingotRefinedIron"});
            RollingMachineCraftingManager.getInstance().getRecipeList().add((IRecipe)recipe);
            recipe = new ShapedOreRecipe(stack, new Object[]{"I I", "III", "I I", Character.valueOf('I'), "ingotRefinedIron"});
            RollingMachineCraftingManager.getInstance().getRecipeList().add((IRecipe)recipe);
        }
        if (blockPost != null && BlockPostMetal.post != null) {
            stackColored = BlockPostMetal.post.getItem(1, Short.MAX_VALUE);
            stackRaw = EnumPost.METAL.getItem();
            for (EnumColor color : EnumColor.values()) {
                outputStack = new ItemStack((Block)BlockPostMetal.post, 8, color.ordinal());
                CraftingPlugin.addShapedOreRecipe(outputStack, "III", "IDI", "III", Character.valueOf('I'), stackRaw, Character.valueOf('D'), color.getDye());
                CraftingPlugin.addShapedOreRecipe(outputStack, "III", "IDI", "III", Character.valueOf('I'), stackColored, Character.valueOf('D'), color.getDye());
            }
        }
        if (BlockPostMetal.post != null && BlockPostMetal.platform != null) {
            stackColored = BlockPostMetal.platform.getItem(1, Short.MAX_VALUE);
            stackRaw = EnumPost.METAL_PLATFORM.getItem();
            for (EnumColor color : EnumColor.values()) {
                outputStack = new ItemStack((Block)BlockPostMetal.platform, 8, color.ordinal());
                CraftingPlugin.addShapedOreRecipe(outputStack, "III", "IDI", "III", Character.valueOf('I'), stackRaw, Character.valueOf('D'), color.getDye());
                CraftingPlugin.addShapedOreRecipe(outputStack, "III", "IDI", "III", Character.valueOf('I'), stackColored, Character.valueOf('D'), color.getDye());
            }
        }
    }

    @Override
    public void postInit() {
        EnumCube cubeType;
        if (BlockStrengthGlass.getBlock() != null) {
            Object[] frameTypes = new Object[]{"ingotTin", Items.field_151042_j};
            FluidStack water = Fluids.WATER.get(1000);
            for (ItemStack container : FluidHelper.getContainersFilledWith(water)) {
                for (Object frame : frameTypes) {
                    CraftingPlugin.addShapedOreRecipe(BlockStrengthGlass.getItem(6, 0), "GFG", "GSG", "GWG", Character.valueOf('G'), new ItemStack(Blocks.field_150359_w), Character.valueOf('F'), frame, Character.valueOf('S'), "dustSaltpeter", Character.valueOf('W'), container);
                }
            }
        }
        if ((cubeType = EnumCube.CREOSOTE_BLOCK).isEnabled()) {
            ItemStack stack = cubeType.getItem();
            for (ItemStack container : FluidHelper.getContainersFilledWith(Fluids.CREOSOTE.get(1000))) {
                CraftingPlugin.addShapelessOreRecipe(stack, "logWood", container);
            }
            ForestryPlugin.addCarpenterRecipe("creosote.block", 40, Fluids.CREOSOTE.get(750), null, stack, "L", Character.valueOf('L'), "logWood");
        }
    }
}

